% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmoviz.R
\name{multipleInsertionDiagram}
\alias{multipleInsertionDiagram}
\title{Display multiple insertion events around a genome}
\usage{
multipleInsertionDiagram(insertion_data, genome_ideogram_data,
  either_side = "default", track_height = 0.15, style = 1,
  colour_set = nice_colours, coverage_rectangle = NULL,
  coverage_data = NULL, label_data = NULL, label_colour = "black",
  label_size = 1, xaxis_spacing = "start_end")
}
\arguments{
\item{insertion_data}{A \code{\link{GRanges}} or data frame describing each
of the insertion events. Please see \code{\link{insertionDiagram}} for a
detailed description of the format.}

\item{genome_ideogram_data}{Either a \code{\link{GRanges}} representing
regions of interest or a data frame in bed format (containing the chr,
start and end columns). If you want to read in data from file, please see
the \code{\link{getIdeogramData}} function.}

\item{either_side}{How much extra of the genome should be shown around the
insertion site. See \code{\link{insertionDiagram}} for a description of the
different ways you can specify \code{either_side}, but note that for this
function you need to supply either one value (which will apply to all of
the events) or a named list of values (with one element per event. The names
should be the names of the insertion _NOT_ the names of the chromosomes).}

\item{track_height}{The height (vertical distance around the circle) that
will be taken up by this track. Should be a number between 0 (none) and 1
(entire circle) that will apply to all of the events.}

\item{style}{How the original sequence and insertions are positioned around
the circle (style 1, 2, 3 or 4). Please see the examples of the
\code{\link{insertionDiagram}} function or the vignette for what each of
these options look like. This should be either a single value (which will
apply to all of the events) or a named vector of values (with one element
per event).}

\item{colour_set}{The set of colours that will be used to create the
diagram. For simplicity, it isn't possible to specify precisely the colour
of each sector and link in the diagram (but you can easily edit them by
saving the diagram in a vectorised format and opening it in any vector
graphics editing program). See \code{\link{colourSets}} for the built-in
gmoviz colour sets or make your own (should be a vector of hex colours; must
have a length greater than or equal to the number of rows
of genome_ideogram_data)}

\item{coverage_rectangle}{A vector containing the name(s) of any sector(s)
that you would like to depict as 'coverage rectangles': filled in shapes
that are a plot of the coverage data over that sector. See the example below
or the vignette for an example of this.}

\item{coverage_data}{A GRanges (or data frame) containing the coverage data
to plot for those sectors in \code{coverage_rectangle}. To read this data in
from a BAM file, please see the \code{\link{getCoverage}} function.}

\item{label_data}{Data frame or \linkS4class{GRanges} containing the
labels. If a GRanges, \code{label} should be a metadata column containing
the character strings of the labels. \code{type} and \code{colour} can also
be used to store additional information about the type (e.g. 'gene' or
'promoter') and colour of the label. This information can be used to
\bold{colour code} the labels by supplying the colour column as the
\code{label_colour} parameter. Data frames should additionally include the
\code{chr}, \code{start}, \code{end} which dictate the position of the
label.}

\item{label_colour}{Colour of the labels, can be either a single value
(applied to all labels) or a vector with the same length as the number of
labels (for colour-coding).}

\item{label_size}{Size of the labels.}

\item{xaxis_spacing}{Space between the x axis labels, in degrees.
Alternatively, the string 'start_end' will place a label at the start and
end of each sector only. Accepts only a single value which will be applied
to all events.}
}
\value{
Generates an image of the multiple insertion events provided.
}
\description{
Generates a diagram which displays multiple insertion events
(as displayed using the \code{\link{insertionDiagram}} function) around a
central genome
}
\section{Warning}{

Due to space limitations, it isn't possible to display more than 8 events
or more than 3 events in the same quarter of the circle. If you have more
events than this, please consider splitting them across two or more figures.
}

\examples{
## the data
ideogram_data <- GRanges(
seqnames=paste0('chr', 1:6), ranges=IRanges(start=rep(0, 6),
 end=rep(12000, 6)))
insertion_data <- GRanges(
seqnames = c('chr1', 'chr5'),
ranges = IRanges(start = c(4000, 2000), end = c(4100, 2200)),
name = c('ins1', 'ins5'), length = c(100, 200))

## the plot
multipleInsertionDiagram(insertion_data=insertion_data,
                         genome_ideogram_data=ideogram_data)
## with coverage and labels
example_labels <- GRanges(seqnames=c('chr1', 'chr5'),
                          ranges=IRanges(start=c(4000, 2000),
                          end=c(4120, 2200)),
                          label=c('Gene A', 'Gene B'),
                          colour=c('red', 'blue'))

example_coverage <- GRanges(
seqnames = c(rep('chr1', 100), rep('chr5', 100)),
ranges = IRanges(start=c(seq(4000, 4099, length.out=100),
                         seq(2000, 2199, length.out=100)),
                 end=c(seq(4001, 4100, length.out=100),
                       seq(2001, 2200, length.out=100))),
                 coverage=c(runif(100, 0, 25), runif(100, 0, 15)))
multipleInsertionDiagram(insertion_data=insertion_data,
                         genome_ideogram_data=ideogram_data,
                         label_data=example_labels,
                         label_colour=example_labels$colour,
                         coverage_rectangle=c('chr1', 'chr5'),
                         coverage_data=example_coverage)
## changing either_side and style
either_side_GRange <- GRanges('chr5', IRanges(1000, 3200))
multipleInsertionDiagram(insertion_data=insertion_data,
                         genome_ideogram_data=ideogram_data,
                         style=c('ins1'=1, 'ins5'=4),
                         either_side=list('ins1'=500,
                                            'ins5'=either_side_GRange))

}
\seealso{
\code{\link{insertionDiagram}} for a function which generates the
figures for each of the individual events and \code{\link{gmovizInitialise}}
for the function which draws the central genome
}
