static char rcsid[] = "$Id: oligo.c 99737 2013-06-27 19:33:03Z twu $";
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "oligo.h" 
#include <stdio.h>
#include <stdlib.h>
#include "mem.h"
#include "types.h"
#include "indexdb_hr.h"


#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif

/* Output of positions */
#ifdef DEBUG1
#define debug1(x) x
#else
#define debug1(x)
#endif

/* Oligo_repetitive_p */
#ifdef DEBUG2
#define debug2(x) x
#else
#define debug2(x)
#endif


#define NREPETITIVE 76		/* same for 6 through 15 */
static Storedoligomer_T repetitive_oligos_6[NREPETITIVE] =
  {0, /* AAAAAA */
   65, /* AACAAC */
   130, /* AAGAAG */
   195, /* AATAAT */
   260, /* ACAACA */
   273, /* ACACAC */
   325, /* ACCACC */
   390, /* ACGACG */
   455, /* ACTACT */
   520, /* AGAAGA */
   546, /* AGAGAG */
   585, /* AGCAGC */
   650, /* AGGAGG */
   715, /* AGTAGT */
   780, /* ATAATA */
   819, /* ATATAT */
   845, /* ATCATC */
   910, /* ATGATG */
   975, /* ATTATT */
   1040, /* CAACAA */
   1092, /* CACACA */
   1105, /* CACCAC */
   1170, /* CAGCAG */
   1235, /* CATCAT */
   1300, /* CCACCA */
   1365, /* CCCCCC */
   1430, /* CCGCCG */
   1495, /* CCTCCT */
   1560, /* CGACGA */
   1625, /* CGCCGC */
   1638, /* CGCGCG */
   1690, /* CGGCGG */
   1755, /* CGTCGT */
   1820, /* CTACTA */
   1885, /* CTCCTC */
   1911, /* CTCTCT */
   1950, /* CTGCTG */
   2015, /* CTTCTT */
   2080, /* GAAGAA */
   2145, /* GACGAC */
   2184, /* GAGAGA */
   2210, /* GAGGAG */
   2275, /* GATGAT */
   2340, /* GCAGCA */
   2405, /* GCCGCC */
   2457, /* GCGCGC */
   2470, /* GCGGCG */
   2535, /* GCTGCT */
   2600, /* GGAGGA */
   2665, /* GGCGGC */
   2730, /* GGGGGG */
   2795, /* GGTGGT */
   2860, /* GTAGTA */
   2925, /* GTCGTC */
   2990, /* GTGGTG */
   3003, /* GTGTGT */
   3055, /* GTTGTT */
   3120, /* TAATAA */
   3185, /* TACTAC */
   3250, /* TAGTAG */
   3276, /* TATATA */
   3315, /* TATTAT */
   3380, /* TCATCA */
   3445, /* TCCTCC */
   3510, /* TCGTCG */
   3549, /* TCTCTC */
   3575, /* TCTTCT */
   3640, /* TGATGA */
   3705, /* TGCTGC */
   3770, /* TGGTGG */
   3822, /* TGTGTG */
   3835, /* TGTTGT */
   3900, /* TTATTA */
   3965, /* TTCTTC */
   4030, /* TTGTTG */
   4095, /* TTTTTT */
  };

static Storedoligomer_T repetitive_oligos_7[NREPETITIVE] =
  {0, /* AAAAAAA */
   260, /* AACAACA */
   520, /* AAGAAGA */
   780, /* AATAATA */
   1040, /* ACAACAA */
   1092, /* ACACACA */
   1300, /* ACCACCA */
   1560, /* ACGACGA */
   1820, /* ACTACTA */
   2080, /* AGAAGAA */
   2184, /* AGAGAGA */
   2340, /* AGCAGCA */
   2600, /* AGGAGGA */
   2860, /* AGTAGTA */
   3120, /* ATAATAA */
   3276, /* ATATATA */
   3380, /* ATCATCA */
   3640, /* ATGATGA */
   3900, /* ATTATTA */
   4161, /* CAACAAC */
   4369, /* CACACAC */
   4421, /* CACCACC */
   4681, /* CAGCAGC */
   4941, /* CATCATC */
   5201, /* CCACCAC */
   5461, /* CCCCCCC */
   5721, /* CCGCCGC */
   5981, /* CCTCCTC */
   6241, /* CGACGAC */
   6501, /* CGCCGCC */
   6553, /* CGCGCGC */
   6761, /* CGGCGGC */
   7021, /* CGTCGTC */
   7281, /* CTACTAC */
   7541, /* CTCCTCC */
   7645, /* CTCTCTC */
   7801, /* CTGCTGC */
   8061, /* CTTCTTC */
   8322, /* GAAGAAG */
   8582, /* GACGACG */
   8738, /* GAGAGAG */
   8842, /* GAGGAGG */
   9102, /* GATGATG */
   9362, /* GCAGCAG */
   9622, /* GCCGCCG */
   9830, /* GCGCGCG */
   9882, /* GCGGCGG */
   10142, /* GCTGCTG */
   10402, /* GGAGGAG */
   10662, /* GGCGGCG */
   10922, /* GGGGGGG */
   11182, /* GGTGGTG */
   11442, /* GTAGTAG */
   11702, /* GTCGTCG */
   11962, /* GTGGTGG */
   12014, /* GTGTGTG */
   12222, /* GTTGTTG */
   12483, /* TAATAAT */
   12743, /* TACTACT */
   13003, /* TAGTAGT */
   13107, /* TATATAT */
   13263, /* TATTATT */
   13523, /* TCATCAT */
   13783, /* TCCTCCT */
   14043, /* TCGTCGT */
   14199, /* TCTCTCT */
   14303, /* TCTTCTT */
   14563, /* TGATGAT */
   14823, /* TGCTGCT */
   15083, /* TGGTGGT */
   15291, /* TGTGTGT */
   15343, /* TGTTGTT */
   15603, /* TTATTAT */
   15863, /* TTCTTCT */
   16123, /* TTGTTGT */
   16383, /* TTTTTTT */
  };

static Storedoligomer_T repetitive_oligos_8[NREPETITIVE] =
  {0, /* AAAAAAAA */
   1040, /* AACAACAA */
   2080, /* AAGAAGAA */
   3120, /* AATAATAA */
   4161, /* ACAACAAC */
   4369, /* ACACACAC */
   5201, /* ACCACCAC */
   6241, /* ACGACGAC */
   7281, /* ACTACTAC */
   8322, /* AGAAGAAG */
   8738, /* AGAGAGAG */
   9362, /* AGCAGCAG */
   10402, /* AGGAGGAG */
   11442, /* AGTAGTAG */
   12483, /* ATAATAAT */
   13107, /* ATATATAT */
   13523, /* ATCATCAT */
   14563, /* ATGATGAT */
   15603, /* ATTATTAT */
   16644, /* CAACAACA */
   17476, /* CACACACA */
   17684, /* CACCACCA */
   18724, /* CAGCAGCA */
   19764, /* CATCATCA */
   20805, /* CCACCACC */
   21845, /* CCCCCCCC */
   22885, /* CCGCCGCC */
   23925, /* CCTCCTCC */
   24966, /* CGACGACG */
   26006, /* CGCCGCCG */
   26214, /* CGCGCGCG */
   27046, /* CGGCGGCG */
   28086, /* CGTCGTCG */
   29127, /* CTACTACT */
   30167, /* CTCCTCCT */
   30583, /* CTCTCTCT */
   31207, /* CTGCTGCT */
   32247, /* CTTCTTCT */
   33288, /* GAAGAAGA */
   34328, /* GACGACGA */
   34952, /* GAGAGAGA */
   35368, /* GAGGAGGA */
   36408, /* GATGATGA */
   37449, /* GCAGCAGC */
   38489, /* GCCGCCGC */
   39321, /* GCGCGCGC */
   39529, /* GCGGCGGC */
   40569, /* GCTGCTGC */
   41610, /* GGAGGAGG */
   42650, /* GGCGGCGG */
   43690, /* GGGGGGGG */
   44730, /* GGTGGTGG */
   45771, /* GTAGTAGT */
   46811, /* GTCGTCGT */
   47851, /* GTGGTGGT */
   48059, /* GTGTGTGT */
   48891, /* GTTGTTGT */
   49932, /* TAATAATA */
   50972, /* TACTACTA */
   52012, /* TAGTAGTA */
   52428, /* TATATATA */
   53052, /* TATTATTA */
   54093, /* TCATCATC */
   55133, /* TCCTCCTC */
   56173, /* TCGTCGTC */
   56797, /* TCTCTCTC */
   57213, /* TCTTCTTC */
   58254, /* TGATGATG */
   59294, /* TGCTGCTG */
   60334, /* TGGTGGTG */
   61166, /* TGTGTGTG */
   61374, /* TGTTGTTG */
   62415, /* TTATTATT */
   63455, /* TTCTTCTT */
   64495, /* TTGTTGTT */
   65535, /* TTTTTTTT */
  };

static Storedoligomer_T repetitive_oligos_9[NREPETITIVE] =
  {0, /* AAAAAAAAA */
   4161, /* AACAACAAC */
   8322, /* AAGAAGAAG */
   12483, /* AATAATAAT */
   16644, /* ACAACAACA */
   17476, /* ACACACACA */
   20805, /* ACCACCACC */
   24966, /* ACGACGACG */
   29127, /* ACTACTACT */
   33288, /* AGAAGAAGA */
   34952, /* AGAGAGAGA */
   37449, /* AGCAGCAGC */
   41610, /* AGGAGGAGG */
   45771, /* AGTAGTAGT */
   49932, /* ATAATAATA */
   52428, /* ATATATATA */
   54093, /* ATCATCATC */
   58254, /* ATGATGATG */
   62415, /* ATTATTATT */
   66576, /* CAACAACAA */
   69905, /* CACACACAC */
   70737, /* CACCACCAC */
   74898, /* CAGCAGCAG */
   79059, /* CATCATCAT */
   83220, /* CCACCACCA */
   87381, /* CCCCCCCCC */
   91542, /* CCGCCGCCG */
   95703, /* CCTCCTCCT */
   99864, /* CGACGACGA */
   104025, /* CGCCGCCGC */
   104857, /* CGCGCGCGC */
   108186, /* CGGCGGCGG */
   112347, /* CGTCGTCGT */
   116508, /* CTACTACTA */
   120669, /* CTCCTCCTC */
   122333, /* CTCTCTCTC */
   124830, /* CTGCTGCTG */
   128991, /* CTTCTTCTT */
   133152, /* GAAGAAGAA */
   137313, /* GACGACGAC */
   139810, /* GAGAGAGAG */
   141474, /* GAGGAGGAG */
   145635, /* GATGATGAT */
   149796, /* GCAGCAGCA */
   153957, /* GCCGCCGCC */
   157286, /* GCGCGCGCG */
   158118, /* GCGGCGGCG */
   162279, /* GCTGCTGCT */
   166440, /* GGAGGAGGA */
   170601, /* GGCGGCGGC */
   174762, /* GGGGGGGGG */
   178923, /* GGTGGTGGT */
   183084, /* GTAGTAGTA */
   187245, /* GTCGTCGTC */
   191406, /* GTGGTGGTG */
   192238, /* GTGTGTGTG */
   195567, /* GTTGTTGTT */
   199728, /* TAATAATAA */
   203889, /* TACTACTAC */
   208050, /* TAGTAGTAG */
   209715, /* TATATATAT */
   212211, /* TATTATTAT */
   216372, /* TCATCATCA */
   220533, /* TCCTCCTCC */
   224694, /* TCGTCGTCG */
   227191, /* TCTCTCTCT */
   228855, /* TCTTCTTCT */
   233016, /* TGATGATGA */
   237177, /* TGCTGCTGC */
   241338, /* TGGTGGTGG */
   244667, /* TGTGTGTGT */
   245499, /* TGTTGTTGT */
   249660, /* TTATTATTA */
   253821, /* TTCTTCTTC */
   257982, /* TTGTTGTTG */
   262143, /* TTTTTTTTT */
  };


static Storedoligomer_T repetitive_oligos_10[NREPETITIVE] =
  {0, /* AAAAAAAAAA */
   16644, /* AACAACAACA */
   33288, /* AAGAAGAAGA */
   49932, /* AATAATAATA */
   66576, /* ACAACAACAA */
   69905, /* ACACACACAC */
   83220, /* ACCACCACCA */
   99864, /* ACGACGACGA */
   116508, /* ACTACTACTA */
   133152, /* AGAAGAAGAA */
   139810, /* AGAGAGAGAG */
   149796, /* AGCAGCAGCA */
   166440, /* AGGAGGAGGA */
   183084, /* AGTAGTAGTA */
   199728, /* ATAATAATAA */
   209715, /* ATATATATAT */
   216372, /* ATCATCATCA */
   233016, /* ATGATGATGA */
   249660, /* ATTATTATTA */
   266305, /* CAACAACAAC */
   279620, /* CACACACACA */
   282949, /* CACCACCACC */
   299593, /* CAGCAGCAGC */
   316237, /* CATCATCATC */
   332881, /* CCACCACCAC */
   349525, /* CCCCCCCCCC */
   366169, /* CCGCCGCCGC */
   382813, /* CCTCCTCCTC */
   399457, /* CGACGACGAC */
   416101, /* CGCCGCCGCC */
   419430, /* CGCGCGCGCG */
   432745, /* CGGCGGCGGC */
   449389, /* CGTCGTCGTC */
   466033, /* CTACTACTAC */
   482677, /* CTCCTCCTCC */
   489335, /* CTCTCTCTCT */
   499321, /* CTGCTGCTGC */
   515965, /* CTTCTTCTTC */
   532610, /* GAAGAAGAAG */
   549254, /* GACGACGACG */
   559240, /* GAGAGAGAGA */
   565898, /* GAGGAGGAGG */
   582542, /* GATGATGATG */
   599186, /* GCAGCAGCAG */
   615830, /* GCCGCCGCCG */
   629145, /* GCGCGCGCGC */
   632474, /* GCGGCGGCGG */
   649118, /* GCTGCTGCTG */
   665762, /* GGAGGAGGAG */
   682406, /* GGCGGCGGCG */
   699050, /* GGGGGGGGGG */
   715694, /* GGTGGTGGTG */
   732338, /* GTAGTAGTAG */
   748982, /* GTCGTCGTCG */
   765626, /* GTGGTGGTGG */
   768955, /* GTGTGTGTGT */
   782270, /* GTTGTTGTTG */
   798915, /* TAATAATAAT */
   815559, /* TACTACTACT */
   832203, /* TAGTAGTAGT */
   838860, /* TATATATATA */
   848847, /* TATTATTATT */
   865491, /* TCATCATCAT */
   882135, /* TCCTCCTCCT */
   898779, /* TCGTCGTCGT */
   908765, /* TCTCTCTCTC */
   915423, /* TCTTCTTCTT */
   932067, /* TGATGATGAT */
   948711, /* TGCTGCTGCT */
   965355, /* TGGTGGTGGT */
   978670, /* TGTGTGTGTG */
   981999, /* TGTTGTTGTT */
   998643, /* TTATTATTAT */
   1015287, /* TTCTTCTTCT */
   1031931, /* TTGTTGTTGT */
   1048575, /* TTTTTTTTTT */
  };


static Storedoligomer_T repetitive_oligos_11[NREPETITIVE] =
  {0, /* AAAAAAAAAAA */
   66576, /* AACAACAACAA */
   133152, /* AAGAAGAAGAA */
   199728, /* AATAATAATAA */
   266305, /* ACAACAACAAC */
   279620, /* ACACACACACA */
   332881, /* ACCACCACCAC */
   399457, /* ACGACGACGAC */
   466033, /* ACTACTACTAC */
   532610, /* AGAAGAAGAAG */
   559240, /* AGAGAGAGAGA */
   599186, /* AGCAGCAGCAG */
   665762, /* AGGAGGAGGAG */
   732338, /* AGTAGTAGTAG */
   798915, /* ATAATAATAAT */
   838860, /* ATATATATATA */
   865491, /* ATCATCATCAT */
   932067, /* ATGATGATGAT */
   998643, /* ATTATTATTAT */
   1065220, /* CAACAACAACA */
   1118481, /* CACACACACAC */
   1131796, /* CACCACCACCA */
   1198372, /* CAGCAGCAGCA */
   1264948, /* CATCATCATCA */
   1331525, /* CCACCACCACC */
   1398101, /* CCCCCCCCCCC */
   1464677, /* CCGCCGCCGCC */
   1531253, /* CCTCCTCCTCC */
   1597830, /* CGACGACGACG */
   1664406, /* CGCCGCCGCCG */
   1677721, /* CGCGCGCGCGC */
   1730982, /* CGGCGGCGGCG */
   1797558, /* CGTCGTCGTCG */
   1864135, /* CTACTACTACT */
   1930711, /* CTCCTCCTCCT */
   1957341, /* CTCTCTCTCTC */
   1997287, /* CTGCTGCTGCT */
   2063863, /* CTTCTTCTTCT */
   2130440, /* GAAGAAGAAGA */
   2197016, /* GACGACGACGA */
   2236962, /* GAGAGAGAGAG */
   2263592, /* GAGGAGGAGGA */
   2330168, /* GATGATGATGA */
   2396745, /* GCAGCAGCAGC */
   2463321, /* GCCGCCGCCGC */
   2516582, /* GCGCGCGCGCG */
   2529897, /* GCGGCGGCGGC */
   2596473, /* GCTGCTGCTGC */
   2663050, /* GGAGGAGGAGG */
   2729626, /* GGCGGCGGCGG */
   2796202, /* GGGGGGGGGGG */
   2862778, /* GGTGGTGGTGG */
   2929355, /* GTAGTAGTAGT */
   2995931, /* GTCGTCGTCGT */
   3062507, /* GTGGTGGTGGT */
   3075822, /* GTGTGTGTGTG */
   3129083, /* GTTGTTGTTGT */
   3195660, /* TAATAATAATA */
   3262236, /* TACTACTACTA */
   3328812, /* TAGTAGTAGTA */
   3355443, /* TATATATATAT */
   3395388, /* TATTATTATTA */
   3461965, /* TCATCATCATC */
   3528541, /* TCCTCCTCCTC */
   3595117, /* TCGTCGTCGTC */
   3635063, /* TCTCTCTCTCT */
   3661693, /* TCTTCTTCTTC */
   3728270, /* TGATGATGATG */
   3794846, /* TGCTGCTGCTG */
   3861422, /* TGGTGGTGGTG */
   3914683, /* TGTGTGTGTGT */
   3927998, /* TGTTGTTGTTG */
   3994575, /* TTATTATTATT */
   4061151, /* TTCTTCTTCTT */
   4127727, /* TTGTTGTTGTT */
   4194303, /* TTTTTTTTTTT */
  };


static Storedoligomer_T repetitive_oligos_12[NREPETITIVE] =
  {0, /* AAAAAAAAAAAA */
   266305, /* AACAACAACAAC */
   532610, /* AAGAAGAAGAAG */
   798915, /* AATAATAATAAT */
   1065220, /* ACAACAACAACA */
   1118481, /* ACACACACACAC */
   1331525, /* ACCACCACCACC */
   1597830, /* ACGACGACGACG */
   1864135, /* ACTACTACTACT */
   2130440, /* AGAAGAAGAAGA */
   2236962, /* AGAGAGAGAGAG */
   2396745, /* AGCAGCAGCAGC */
   2663050, /* AGGAGGAGGAGG */
   2929355, /* AGTAGTAGTAGT */
   3195660, /* ATAATAATAATA */
   3355443, /* ATATATATATAT */
   3461965, /* ATCATCATCATC */
   3728270, /* ATGATGATGATG */
   3994575, /* ATTATTATTATT */
   4260880, /* CAACAACAACAA */
   4473924, /* CACACACACACA */
   4527185, /* CACCACCACCAC */
   4793490, /* CAGCAGCAGCAG */
   5059795, /* CATCATCATCAT */
   5326100, /* CCACCACCACCA */
   5592405, /* CCCCCCCCCCCC */
   5858710, /* CCGCCGCCGCCG */
   6125015, /* CCTCCTCCTCCT */
   6391320, /* CGACGACGACGA */
   6657625, /* CGCCGCCGCCGC */
   6710886, /* CGCGCGCGCGCG */
   6923930, /* CGGCGGCGGCGG */
   7190235, /* CGTCGTCGTCGT */
   7456540, /* CTACTACTACTA */
   7722845, /* CTCCTCCTCCTC */
   7829367, /* CTCTCTCTCTCT */
   7989150, /* CTGCTGCTGCTG */
   8255455, /* CTTCTTCTTCTT */
   8521760, /* GAAGAAGAAGAA */
   8788065, /* GACGACGACGAC */
   8947848, /* GAGAGAGAGAGA */
   9054370, /* GAGGAGGAGGAG */
   9320675, /* GATGATGATGAT */
   9586980, /* GCAGCAGCAGCA */
   9853285, /* GCCGCCGCCGCC */
   10066329, /* GCGCGCGCGCGC */
   10119590, /* GCGGCGGCGGCG */
   10385895, /* GCTGCTGCTGCT */
   10652200, /* GGAGGAGGAGGA */
   10918505, /* GGCGGCGGCGGC */
   11184810, /* GGGGGGGGGGGG */
   11451115, /* GGTGGTGGTGGT */
   11717420, /* GTAGTAGTAGTA */
   11983725, /* GTCGTCGTCGTC */
   12250030, /* GTGGTGGTGGTG */
   12303291, /* GTGTGTGTGTGT */
   12516335, /* GTTGTTGTTGTT */
   12782640, /* TAATAATAATAA */
   13048945, /* TACTACTACTAC */
   13315250, /* TAGTAGTAGTAG */
   13421772, /* TATATATATATA */
   13581555, /* TATTATTATTAT */
   13847860, /* TCATCATCATCA */
   14114165, /* TCCTCCTCCTCC */
   14380470, /* TCGTCGTCGTCG */
   14540253, /* TCTCTCTCTCTC */
   14646775, /* TCTTCTTCTTCT */
   14913080, /* TGATGATGATGA */
   15179385, /* TGCTGCTGCTGC */
   15445690, /* TGGTGGTGGTGG */
   15658734, /* TGTGTGTGTGTG */
   15711995, /* TGTTGTTGTTGT */
   15978300, /* TTATTATTATTA */
   16244605, /* TTCTTCTTCTTC */
   16510910, /* TTGTTGTTGTTG */
   16777215, /* TTTTTTTTTTTT */
  };

static Storedoligomer_T repetitive_oligos_13[NREPETITIVE] =
  {0, /* AAAAAAAAAAAAA */
   1065220, /* AACAACAACAACA */
   2130440, /* AAGAAGAAGAAGA */
   3195660, /* AATAATAATAATA */
   4260880, /* ACAACAACAACAA */
   4473924, /* ACACACACACACA */
   5326100, /* ACCACCACCACCA */
   6391320, /* ACGACGACGACGA */
   7456540, /* ACTACTACTACTA */
   8521760, /* AGAAGAAGAAGAA */
   8947848, /* AGAGAGAGAGAGA */
   9586980, /* AGCAGCAGCAGCA */
   10652200, /* AGGAGGAGGAGGA */
   11717420, /* AGTAGTAGTAGTA */
   12782640, /* ATAATAATAATAA */
   13421772, /* ATATATATATATA */
   13847860, /* ATCATCATCATCA */
   14913080, /* ATGATGATGATGA */
   15978300, /* ATTATTATTATTA */
   17043521, /* CAACAACAACAAC */
   17895697, /* CACACACACACAC */
   18108741, /* CACCACCACCACC */
   19173961, /* CAGCAGCAGCAGC */
   20239181, /* CATCATCATCATC */
   21304401, /* CCACCACCACCAC */
   22369621, /* CCCCCCCCCCCCC */
   23434841, /* CCGCCGCCGCCGC */
   24500061, /* CCTCCTCCTCCTC */
   25565281, /* CGACGACGACGAC */
   26630501, /* CGCCGCCGCCGCC */
   26843545, /* CGCGCGCGCGCGC */
   27695721, /* CGGCGGCGGCGGC */
   28760941, /* CGTCGTCGTCGTC */
   29826161, /* CTACTACTACTAC */
   30891381, /* CTCCTCCTCCTCC */
   31317469, /* CTCTCTCTCTCTC */
   31956601, /* CTGCTGCTGCTGC */
   33021821, /* CTTCTTCTTCTTC */
   34087042, /* GAAGAAGAAGAAG */
   35152262, /* GACGACGACGACG */
   35791394, /* GAGAGAGAGAGAG */
   36217482, /* GAGGAGGAGGAGG */
   37282702, /* GATGATGATGATG */
   38347922, /* GCAGCAGCAGCAG */
   39413142, /* GCCGCCGCCGCCG */
   40265318, /* GCGCGCGCGCGCG */
   40478362, /* GCGGCGGCGGCGG */
   41543582, /* GCTGCTGCTGCTG */
   42608802, /* GGAGGAGGAGGAG */
   43674022, /* GGCGGCGGCGGCG */
   44739242, /* GGGGGGGGGGGGG */
   45804462, /* GGTGGTGGTGGTG */
   46869682, /* GTAGTAGTAGTAG */
   47934902, /* GTCGTCGTCGTCG */
   49000122, /* GTGGTGGTGGTGG */
   49213166, /* GTGTGTGTGTGTG */
   50065342, /* GTTGTTGTTGTTG */
   51130563, /* TAATAATAATAAT */
   52195783, /* TACTACTACTACT */
   53261003, /* TAGTAGTAGTAGT */
   53687091, /* TATATATATATAT */
   54326223, /* TATTATTATTATT */
   55391443, /* TCATCATCATCAT */
   56456663, /* TCCTCCTCCTCCT */
   57521883, /* TCGTCGTCGTCGT */
   58161015, /* TCTCTCTCTCTCT */
   58587103, /* TCTTCTTCTTCTT */
   59652323, /* TGATGATGATGAT */
   60717543, /* TGCTGCTGCTGCT */
   61782763, /* TGGTGGTGGTGGT */
   62634939, /* TGTGTGTGTGTGT */
   62847983, /* TGTTGTTGTTGTT */
   63913203, /* TTATTATTATTAT */
   64978423, /* TTCTTCTTCTTCT */
   66043643, /* TTGTTGTTGTTGT */
   67108863, /* TTTTTTTTTTTTT */
  };


static Storedoligomer_T repetitive_oligos_14[NREPETITIVE] =
  {0, /* AAAAAAAAAAAAAA */
   4260880, /* AACAACAACAACAA */
   8521760, /* AAGAAGAAGAAGAA */
   12782640, /* AATAATAATAATAA */
   17043521, /* ACAACAACAACAAC */
   17895697, /* ACACACACACACAC */
   21304401, /* ACCACCACCACCAC */
   25565281, /* ACGACGACGACGAC */
   29826161, /* ACTACTACTACTAC */
   34087042, /* AGAAGAAGAAGAAG */
   35791394, /* AGAGAGAGAGAGAG */
   38347922, /* AGCAGCAGCAGCAG */
   42608802, /* AGGAGGAGGAGGAG */
   46869682, /* AGTAGTAGTAGTAG */
   51130563, /* ATAATAATAATAAT */
   53687091, /* ATATATATATATAT */
   55391443, /* ATCATCATCATCAT */
   59652323, /* ATGATGATGATGAT */
   63913203, /* ATTATTATTATTAT */
   68174084, /* CAACAACAACAACA */
   71582788, /* CACACACACACACA */
   72434964, /* CACCACCACCACCA */
   76695844, /* CAGCAGCAGCAGCA */
   80956724, /* CATCATCATCATCA */
   85217605, /* CCACCACCACCACC */
   89478485, /* CCCCCCCCCCCCCC */
   93739365, /* CCGCCGCCGCCGCC */
   98000245, /* CCTCCTCCTCCTCC */
   102261126, /* CGACGACGACGACG */
   106522006, /* CGCCGCCGCCGCCG */
   107374182, /* CGCGCGCGCGCGCG */
   110782886, /* CGGCGGCGGCGGCG */
   115043766, /* CGTCGTCGTCGTCG */
   119304647, /* CTACTACTACTACT */
   123565527, /* CTCCTCCTCCTCCT */
   125269879, /* CTCTCTCTCTCTCT */
   127826407, /* CTGCTGCTGCTGCT */
   132087287, /* CTTCTTCTTCTTCT */
   136348168, /* GAAGAAGAAGAAGA */
   140609048, /* GACGACGACGACGA */
   143165576, /* GAGAGAGAGAGAGA */
   144869928, /* GAGGAGGAGGAGGA */
   149130808, /* GATGATGATGATGA */
   153391689, /* GCAGCAGCAGCAGC */
   157652569, /* GCCGCCGCCGCCGC */
   161061273, /* GCGCGCGCGCGCGC */
   161913449, /* GCGGCGGCGGCGGC */
   166174329, /* GCTGCTGCTGCTGC */
   170435210, /* GGAGGAGGAGGAGG */
   174696090, /* GGCGGCGGCGGCGG */
   178956970, /* GGGGGGGGGGGGGG */
   183217850, /* GGTGGTGGTGGTGG */
   187478731, /* GTAGTAGTAGTAGT */
   191739611, /* GTCGTCGTCGTCGT */
   196000491, /* GTGGTGGTGGTGGT */
   196852667, /* GTGTGTGTGTGTGT */
   200261371, /* GTTGTTGTTGTTGT */
   204522252, /* TAATAATAATAATA */
   208783132, /* TACTACTACTACTA */
   213044012, /* TAGTAGTAGTAGTA */
   214748364, /* TATATATATATATA */
   217304892, /* TATTATTATTATTA */
   221565773, /* TCATCATCATCATC */
   225826653, /* TCCTCCTCCTCCTC */
   230087533, /* TCGTCGTCGTCGTC */
   232644061, /* TCTCTCTCTCTCTC */
   234348413, /* TCTTCTTCTTCTTC */
   238609294, /* TGATGATGATGATG */
   242870174, /* TGCTGCTGCTGCTG */
   247131054, /* TGGTGGTGGTGGTG */
   250539758, /* TGTGTGTGTGTGTG */
   251391934, /* TGTTGTTGTTGTTG */
   255652815, /* TTATTATTATTATT */
   259913695, /* TTCTTCTTCTTCTT */
   264174575, /* TTGTTGTTGTTGTT */
   268435455, /* TTTTTTTTTTTTTT */
  };

static Storedoligomer_T repetitive_oligos_15[NREPETITIVE] =
  {0, /* AAAAAAAAAAAAAAA */
   17043521, /* AACAACAACAACAAC */
   34087042, /* AAGAAGAAGAAGAAG */
   51130563, /* AATAATAATAATAAT */
   68174084, /* ACAACAACAACAACA */
   71582788, /* ACACACACACACACA */
   85217605, /* ACCACCACCACCACC */
   102261126, /* ACGACGACGACGACG */
   119304647, /* ACTACTACTACTACT */
   136348168, /* AGAAGAAGAAGAAGA */
   143165576, /* AGAGAGAGAGAGAGA */
   153391689, /* AGCAGCAGCAGCAGC */
   170435210, /* AGGAGGAGGAGGAGG */
   187478731, /* AGTAGTAGTAGTAGT */
   204522252, /* ATAATAATAATAATA */
   214748364, /* ATATATATATATATA */
   221565773, /* ATCATCATCATCATC */
   238609294, /* ATGATGATGATGATG */
   255652815, /* ATTATTATTATTATT */
   272696336, /* CAACAACAACAACAA */
   286331153, /* CACACACACACACAC */
   289739857, /* CACCACCACCACCAC */
   306783378, /* CAGCAGCAGCAGCAG */
   323826899, /* CATCATCATCATCAT */
   340870420, /* CCACCACCACCACCA */
   357913941, /* CCCCCCCCCCCCCCC */
   374957462, /* CCGCCGCCGCCGCCG */
   392000983, /* CCTCCTCCTCCTCCT */
   409044504, /* CGACGACGACGACGA */
   426088025, /* CGCCGCCGCCGCCGC */
   429496729, /* CGCGCGCGCGCGCGC */
   443131546, /* CGGCGGCGGCGGCGG */
   460175067, /* CGTCGTCGTCGTCGT */
   477218588, /* CTACTACTACTACTA */
   494262109, /* CTCCTCCTCCTCCTC */
   501079517, /* CTCTCTCTCTCTCTC */
   511305630, /* CTGCTGCTGCTGCTG */
   528349151, /* CTTCTTCTTCTTCTT */
   545392672, /* GAAGAAGAAGAAGAA */
   562436193, /* GACGACGACGACGAC */
   572662306, /* GAGAGAGAGAGAGAG */
   579479714, /* GAGGAGGAGGAGGAG */
   596523235, /* GATGATGATGATGAT */
   613566756, /* GCAGCAGCAGCAGCA */
   630610277, /* GCCGCCGCCGCCGCC */
   644245094, /* GCGCGCGCGCGCGCG */
   647653798, /* GCGGCGGCGGCGGCG */
   664697319, /* GCTGCTGCTGCTGCT */
   681740840, /* GGAGGAGGAGGAGGA */
   698784361, /* GGCGGCGGCGGCGGC */
   715827882, /* GGGGGGGGGGGGGGG */
   732871403, /* GGTGGTGGTGGTGGT */
   749914924, /* GTAGTAGTAGTAGTA */
   766958445, /* GTCGTCGTCGTCGTC */
   784001966, /* GTGGTGGTGGTGGTG */
   787410670, /* GTGTGTGTGTGTGTG */
   801045487, /* GTTGTTGTTGTTGTT */
   818089008, /* TAATAATAATAATAA */
   835132529, /* TACTACTACTACTAC */
   852176050, /* TAGTAGTAGTAGTAG */
   858993459, /* TATATATATATATAT */
   869219571, /* TATTATTATTATTAT */
   886263092, /* TCATCATCATCATCA */
   903306613, /* TCCTCCTCCTCCTCC */
   920350134, /* TCGTCGTCGTCGTCG */
   930576247, /* TCTCTCTCTCTCTCT */
   937393655, /* TCTTCTTCTTCTTCT */
   954437176, /* TGATGATGATGATGA */
   971480697, /* TGCTGCTGCTGCTGC */
   988524218, /* TGGTGGTGGTGGTGG */
   1002159035, /* TGTGTGTGTGTGTGT */
   1005567739, /* TGTTGTTGTTGTTGT */
   1022611260, /* TTATTATTATTATTA */
   1039654781, /* TTCTTCTTCTTCTTC */
   1056698302, /* TTGTTGTTGTTGTTG */
   1073741823, /* TTTTTTTTTTTTTTT */
  };

static Storedoligomer_T repetitive_oligos_16[NREPETITIVE] =
  {0, /* AAAAAAAAAAAAAAAA */
   68174084, /* AACAACAACAACAACA */
   136348168, /* AAGAAGAAGAAGAAGA */
   204522252, /* AATAATAATAATAATA */
   272696336, /* ACAACAACAACAACAA */
   286331153, /* ACACACACACACACAC */
   340870420, /* ACCACCACCACCACCA */
   409044504, /* ACGACGACGACGACGA */
   477218588, /* ACTACTACTACTACTA */
   545392672, /* AGAAGAAGAAGAAGAA */
   572662306, /* AGAGAGAGAGAGAGAG */
   613566756, /* AGCAGCAGCAGCAGCA */
   681740840, /* AGGAGGAGGAGGAGGA */
   749914924, /* AGTAGTAGTAGTAGTA */
   818089008, /* ATAATAATAATAATAA */
   858993459, /* ATATATATATATATAT */
   886263092, /* ATCATCATCATCATCA */
   954437176, /* ATGATGATGATGATGA */
   1022611260, /* ATTATTATTATTATTA */
   1090785345, /* CAACAACAACAACAAC */
   1145324612, /* CACACACACACACACA */
   1158959429, /* CACCACCACCACCACC */
   1227133513, /* CAGCAGCAGCAGCAGC */
   1295307597, /* CATCATCATCATCATC */
   1363481681, /* CCACCACCACCACCAC */
   1431655765, /* CCCCCCCCCCCCCCCC */
   1499829849, /* CCGCCGCCGCCGCCGC */
   1568003933, /* CCTCCTCCTCCTCCTC */
   1636178017, /* CGACGACGACGACGAC */
   1704352101, /* CGCCGCCGCCGCCGCC */
   1717986918, /* CGCGCGCGCGCGCGCG */
   1772526185, /* CGGCGGCGGCGGCGGC */
   1840700269, /* CGTCGTCGTCGTCGTC */
   1908874353, /* CTACTACTACTACTAC */
   1977048437, /* CTCCTCCTCCTCCTCC */
   2004318071, /* CTCTCTCTCTCTCTCT */
   2045222521, /* CTGCTGCTGCTGCTGC */
   2113396605, /* CTTCTTCTTCTTCTTC */
   2181570690, /* GAAGAAGAAGAAGAAG */
   2249744774, /* GACGACGACGACGACG */
   2290649224, /* GAGAGAGAGAGAGAGA */
   2317918858, /* GAGGAGGAGGAGGAGG */
   2386092942, /* GATGATGATGATGATG */
   2454267026, /* GCAGCAGCAGCAGCAG */
   2522441110, /* GCCGCCGCCGCCGCCG */
   2576980377, /* GCGCGCGCGCGCGCGC */
   2590615194, /* GCGGCGGCGGCGGCGG */
   2658789278, /* GCTGCTGCTGCTGCTG */
   2726963362, /* GGAGGAGGAGGAGGAG */
   2795137446, /* GGCGGCGGCGGCGGCG */
   2863311530, /* GGGGGGGGGGGGGGGG */
   2931485614, /* GGTGGTGGTGGTGGTG */
   2999659698, /* GTAGTAGTAGTAGTAG */
   3067833782, /* GTCGTCGTCGTCGTCG */
   3136007866, /* GTGGTGGTGGTGGTGG */
   3149642683, /* GTGTGTGTGTGTGTGT */
   3204181950, /* GTTGTTGTTGTTGTTG */
   3272356035, /* TAATAATAATAATAAT */
   3340530119, /* TACTACTACTACTACT */
   3408704203, /* TAGTAGTAGTAGTAGT */
   3435973836, /* TATATATATATATATA */
   3476878287, /* TATTATTATTATTATT */
   3545052371, /* TCATCATCATCATCAT */
   3613226455, /* TCCTCCTCCTCCTCCT */
   3681400539, /* TCGTCGTCGTCGTCGT */
   3722304989, /* TCTCTCTCTCTCTCTC */
   3749574623, /* TCTTCTTCTTCTTCTT */
   3817748707, /* TGATGATGATGATGAT */
   3885922791, /* TGCTGCTGCTGCTGCT */
   3954096875, /* TGGTGGTGGTGGTGGT */
   4008636142, /* TGTGTGTGTGTGTGTG */
   4022270959, /* TGTTGTTGTTGTTGTT */
   4090445043, /* TTATTATTATTATTAT */
   4158619127, /* TTCTTCTTCTTCTTCT */
   4226793211, /* TTGTTGTTGTTGTTGT */
   4294967295, /* TTTTTTTTTTTTTTTT */
  };



#if 0
#define ALL_NREPETITIVE 4336
static Storedoligomer_T all_repetitive_oligos[ALL_NREPETITIVE] =
{       0,    4097,    8194,   12291,   16388,   20485,   24582,   28679,
    32776,   36873,   40970,   45067,   49164,   53261,   57358,   61455,
    65552,   65793,   69649,   73746,   77843,   81940,   86037,   90134,
    94231,   98328,  102425,  106522,  110619,  114716,  118813,  122910,
   127007,  131104,  131586,  135201,  139298,  143395,  147492,  151589,
   155686,  159783,  163880,  167977,  172074,  176171,  180268,  184365,
   188462,  192559,  196656,  197379,  200753,  204850,  208947,  213044,
   217141,  221238,  225335,  229432,  233529,  237626,  241723,  245820,
   249917,  254014,  258111,  262208,  263172,  266305,  270402,  274499,
   278596,  282693,  286790,  290887,  294984,  299081,  303178,  307275,
   311372,  315469,  319566,  323663,  327760,  328965,  331857,  335954,
   340051,  344148,  348245,  352342,  356439,  360536,  364633,  368730,
   372827,  376924,  381021,  385118,  389215,  393312,  394758,  397409,
   401506,  405603,  409700,  413797,  417894,  421991,  426088,  430185,
   434282,  438379,  442476,  446573,  450670,  454767,  458864,  460551,
   462961,  467058,  471155,  475252,  479349,  483446,  487543,  491640,
   495737,  499834,  503931,  508028,  512125,  516222,  520319,  524416,
   526344,  528513,  532610,  536707,  540804,  544901,  548998,  553095,
   557192,  561289,  565386,  569483,  573580,  577677,  581774,  585871,
   589968,  592137,  594065,  598162,  602259,  606356,  610453,  614550,
   618647,  622744,  626841,  630938,  635035,  639132,  643229,  647326,
   651423,  655520,  657930,  659617,  663714,  667811,  671908,  676005,
   680102,  684199,  688296,  692393,  696490,  700587,  704684,  708781,
   712878,  716975,  721072,  723723,  725169,  729266,  733363,  737460,
   741557,  745654,  749751,  753848,  757945,  762042,  766139,  770236,
   774333,  778430,  782527,  786624,  789516,  790721,  794818,  798915,
   803012,  807109,  811206,  815303,  819400,  823497,  827594,  831691,
   835788,  839885,  843982,  848079,  852176,  855309,  856273,  860370,
   864467,  868564,  872661,  876758,  880855,  884952,  889049,  893146,
   897243,  901340,  905437,  909534,  913631,  917728,  921102,  921825,
   925922,  930019,  934116,  938213,  942310,  946407,  950504,  954601,
   958698,  962795,  966892,  970989,  975086,  979183,  983280,  986895,
   987377,  991474,  995571,  999668, 1003765, 1007862, 1011959, 1016056,
  1020153, 1024250, 1028347, 1032444, 1036541, 1040638, 1044735, 1048832,
  1052688, 1052929, 1057026, 1061123, 1065220, 1069317, 1073414, 1077511,
  1081608, 1085705, 1089802, 1093899, 1097996, 1102093, 1106190, 1110287,
  1114384, 1118481, 1122578, 1126675, 1130772, 1134869, 1138966, 1143063,
  1147160, 1151257, 1155354, 1159451, 1163548, 1167645, 1171742, 1175839,
  1179936, 1184033, 1184274, 1188130, 1192227, 1196324, 1200421, 1204518,
  1208615, 1212712, 1216809, 1220906, 1225003, 1229100, 1233197, 1237294,
  1241391, 1245488, 1249585, 1250067, 1253682, 1257779, 1261876, 1265973,
  1270070, 1274167, 1278264, 1282361, 1286458, 1290555, 1294652, 1298749,
  1302846, 1306943, 1311040, 1315137, 1315860, 1319234, 1323331, 1327428,
  1331525, 1335622, 1339719, 1343816, 1347913, 1352010, 1356107, 1360204,
  1364301, 1368398, 1372495, 1376592, 1380689, 1381653, 1384786, 1388883,
  1392980, 1397077, 1401174, 1405271, 1409368, 1413465, 1417562, 1421659,
  1425756, 1429853, 1433950, 1438047, 1442144, 1446241, 1447446, 1450338,
  1454435, 1458532, 1462629, 1466726, 1470823, 1474920, 1479017, 1483114,
  1487211, 1491308, 1495405, 1499502, 1503599, 1507696, 1511793, 1513239,
  1515890, 1519987, 1524084, 1528181, 1532278, 1536375, 1540472, 1544569,
  1548666, 1552763, 1556860, 1560957, 1565054, 1569151, 1573248, 1577345,
  1579032, 1581442, 1585539, 1589636, 1593733, 1597830, 1601927, 1606024,
  1610121, 1614218, 1618315, 1622412, 1626509, 1630606, 1634703, 1638800,
  1642897, 1644825, 1646994, 1651091, 1655188, 1659285, 1663382, 1667479,
  1671576, 1675673, 1679770, 1683867, 1687964, 1692061, 1696158, 1700255,
  1704352, 1708449, 1710618, 1712546, 1716643, 1720740, 1724837, 1728934,
  1733031, 1737128, 1741225, 1745322, 1749419, 1753516, 1757613, 1761710,
  1765807, 1769904, 1774001, 1776411, 1778098, 1782195, 1786292, 1790389,
  1794486, 1798583, 1802680, 1806777, 1810874, 1814971, 1819068, 1823165,
  1827262, 1831359, 1835456, 1839553, 1842204, 1843650, 1847747, 1851844,
  1855941, 1860038, 1864135, 1868232, 1872329, 1876426, 1880523, 1884620,
  1888717, 1892814, 1896911, 1901008, 1905105, 1907997, 1909202, 1913299,
  1917396, 1921493, 1925590, 1929687, 1933784, 1937881, 1941978, 1946075,
  1950172, 1954269, 1958366, 1962463, 1966560, 1970657, 1973790, 1974754,
  1978851, 1982948, 1987045, 1991142, 1995239, 1999336, 2003433, 2007530,
  2011627, 2015724, 2019821, 2023918, 2028015, 2032112, 2036209, 2039583,
  2040306, 2044403, 2048500, 2052597, 2056694, 2060791, 2064888, 2068985,
  2073082, 2077179, 2081276, 2085373, 2089470, 2093567, 2097664, 2101761,
  2105376, 2105858, 2109955, 2114052, 2118149, 2122246, 2126343, 2130440,
  2134537, 2138634, 2142731, 2146828, 2150925, 2155022, 2159119, 2163216,
  2167313, 2171169, 2171410, 2175507, 2179604, 2183701, 2187798, 2191895,
  2195992, 2200089, 2204186, 2208283, 2212380, 2216477, 2220574, 2224671,
  2228768, 2232865, 2236962, 2241059, 2245156, 2249253, 2253350, 2257447,
  2261544, 2265641, 2269738, 2273835, 2277932, 2282029, 2286126, 2290223,
  2294320, 2298417, 2302514, 2302755, 2306611, 2310708, 2314805, 2318902,
  2322999, 2327096, 2331193, 2335290, 2339387, 2343484, 2347581, 2351678,
  2355775, 2359872, 2363969, 2368066, 2368548, 2372163, 2376260, 2380357,
  2384454, 2388551, 2392648, 2396745, 2400842, 2404939, 2409036, 2413133,
  2417230, 2421327, 2425424, 2429521, 2433618, 2434341, 2437715, 2441812,
  2445909, 2450006, 2454103, 2458200, 2462297, 2466394, 2470491, 2474588,
  2478685, 2482782, 2486879, 2490976, 2495073, 2499170, 2500134, 2503267,
  2507364, 2511461, 2515558, 2519655, 2523752, 2527849, 2531946, 2536043,
  2540140, 2544237, 2548334, 2552431, 2556528, 2560625, 2564722, 2565927,
  2568819, 2572916, 2577013, 2581110, 2585207, 2589304, 2593401, 2597498,
  2601595, 2605692, 2609789, 2613886, 2617983, 2622080, 2626177, 2630274,
  2631720, 2634371, 2638468, 2642565, 2646662, 2650759, 2654856, 2658953,
  2663050, 2667147, 2671244, 2675341, 2679438, 2683535, 2687632, 2691729,
  2695826, 2697513, 2699923, 2704020, 2708117, 2712214, 2716311, 2720408,
  2724505, 2728602, 2732699, 2736796, 2740893, 2744990, 2749087, 2753184,
  2757281, 2761378, 2763306, 2765475, 2769572, 2773669, 2777766, 2781863,
  2785960, 2790057, 2794154, 2798251, 2802348, 2806445, 2810542, 2814639,
  2818736, 2822833, 2826930, 2829099, 2831027, 2835124, 2839221, 2843318,
  2847415, 2851512, 2855609, 2859706, 2863803, 2867900, 2871997, 2876094,
  2880191, 2884288, 2888385, 2892482, 2894892, 2896579, 2900676, 2904773,
  2908870, 2912967, 2917064, 2921161, 2925258, 2929355, 2933452, 2937549,
  2941646, 2945743, 2949840, 2953937, 2958034, 2960685, 2962131, 2966228,
  2970325, 2974422, 2978519, 2982616, 2986713, 2990810, 2994907, 2999004,
  3003101, 3007198, 3011295, 3015392, 3019489, 3023586, 3026478, 3027683,
  3031780, 3035877, 3039974, 3044071, 3048168, 3052265, 3056362, 3060459,
  3064556, 3068653, 3072750, 3076847, 3080944, 3085041, 3089138, 3092271,
  3093235, 3097332, 3101429, 3105526, 3109623, 3113720, 3117817, 3121914,
  3126011, 3130108, 3134205, 3138302, 3142399, 3146496, 3150593, 3154690,
  3158064, 3158787, 3162884, 3166981, 3171078, 3175175, 3179272, 3183369,
  3187466, 3191563, 3195660, 3199757, 3203854, 3207951, 3212048, 3216145,
  3220242, 3223857, 3224339, 3228436, 3232533, 3236630, 3240727, 3244824,
  3248921, 3253018, 3257115, 3261212, 3265309, 3269406, 3273503, 3277600,
  3281697, 3285794, 3289650, 3289891, 3293988, 3298085, 3302182, 3306279,
  3310376, 3314473, 3318570, 3322667, 3326764, 3330861, 3334958, 3339055,
  3343152, 3347249, 3351346, 3355443, 3359540, 3363637, 3367734, 3371831,
  3375928, 3380025, 3384122, 3388219, 3392316, 3396413, 3400510, 3404607,
  3408704, 3412801, 3416898, 3420995, 3421236, 3425092, 3429189, 3433286,
  3437383, 3441480, 3445577, 3449674, 3453771, 3457868, 3461965, 3466062,
  3470159, 3474256, 3478353, 3482450, 3486547, 3487029, 3490644, 3494741,
  3498838, 3502935, 3507032, 3511129, 3515226, 3519323, 3523420, 3527517,
  3531614, 3535711, 3539808, 3543905, 3548002, 3552099, 3552822, 3556196,
  3560293, 3564390, 3568487, 3572584, 3576681, 3580778, 3584875, 3588972,
  3593069, 3597166, 3601263, 3605360, 3609457, 3613554, 3617651, 3618615,
  3621748, 3625845, 3629942, 3634039, 3638136, 3642233, 3646330, 3650427,
  3654524, 3658621, 3662718, 3666815, 3670912, 3675009, 3679106, 3683203,
  3684408, 3687300, 3691397, 3695494, 3699591, 3703688, 3707785, 3711882,
  3715979, 3720076, 3724173, 3728270, 3732367, 3736464, 3740561, 3744658,
  3748755, 3750201, 3752852, 3756949, 3761046, 3765143, 3769240, 3773337,
  3777434, 3781531, 3785628, 3789725, 3793822, 3797919, 3802016, 3806113,
  3810210, 3814307, 3815994, 3818404, 3822501, 3826598, 3830695, 3834792,
  3838889, 3842986, 3847083, 3851180, 3855277, 3859374, 3863471, 3867568,
  3871665, 3875762, 3879859, 3881787, 3883956, 3888053, 3892150, 3896247,
  3900344, 3904441, 3908538, 3912635, 3916732, 3920829, 3924926, 3929023,
  3933120, 3937217, 3941314, 3945411, 3947580, 3949508, 3953605, 3957702,
  3961799, 3965896, 3969993, 3974090, 3978187, 3982284, 3986381, 3990478,
  3994575, 3998672, 4002769, 4006866, 4010963, 4013373, 4015060, 4019157,
  4023254, 4027351, 4031448, 4035545, 4039642, 4043739, 4047836, 4051933,
  4056030, 4060127, 4064224, 4068321, 4072418, 4076515, 4079166, 4080612,
  4084709, 4088806, 4092903, 4097000, 4101097, 4105194, 4109291, 4113388,
  4117485, 4121582, 4125679, 4129776, 4133873, 4137970, 4142067, 4144959,
  4146164, 4150261, 4154358, 4158455, 4162552, 4166649, 4170746, 4174843,
  4178940, 4183037, 4187134, 4191231, 4195328, 4199425, 4203522, 4207619,
  4210752, 4211716, 4215813, 4219910, 4224007, 4228104, 4232201, 4236298,
  4240395, 4244492, 4248589, 4252686, 4256783, 4260880, 4264977, 4269074,
  4273171, 4276545, 4277268, 4281365, 4285462, 4289559, 4293656, 4297753,
  4301850, 4305947, 4310044, 4314141, 4318238, 4322335, 4326432, 4330529,
  4334626, 4338723, 4342338, 4342820, 4346917, 4351014, 4355111, 4359208,
  4363305, 4367402, 4371499, 4375596, 4379693, 4383790, 4387887, 4391984,
  4396081, 4400178, 4404275, 4408131, 4408372, 4412469, 4416566, 4420663,
  4424760, 4428857, 4432954, 4437051, 4441148, 4445245, 4449342, 4453439,
  4457536, 4461633, 4465730, 4469827, 4473924, 4478021, 4482118, 4486215,
  4490312, 4494409, 4498506, 4502603, 4506700, 4510797, 4514894, 4518991,
  4523088, 4527185, 4531282, 4535379, 4539476, 4539717, 4543573, 4547670,
  4551767, 4555864, 4559961, 4564058, 4568155, 4572252, 4576349, 4580446,
  4584543, 4588640, 4592737, 4596834, 4600931, 4605028, 4605510, 4609125,
  4613222, 4617319, 4621416, 4625513, 4629610, 4633707, 4637804, 4641901,
  4645998, 4650095, 4654192, 4658289, 4662386, 4666483, 4670580, 4671303,
  4674677, 4678774, 4682871, 4686968, 4691065, 4695162, 4699259, 4703356,
  4707453, 4711550, 4715647, 4719744, 4723841, 4727938, 4732035, 4736132,
  4737096, 4740229, 4744326, 4748423, 4752520, 4756617, 4760714, 4764811,
  4768908, 4773005, 4777102, 4781199, 4785296, 4789393, 4793490, 4797587,
  4801684, 4802889, 4805781, 4809878, 4813975, 4818072, 4822169, 4826266,
  4830363, 4834460, 4838557, 4842654, 4846751, 4850848, 4854945, 4859042,
  4863139, 4867236, 4868682, 4871333, 4875430, 4879527, 4883624, 4887721,
  4891818, 4895915, 4900012, 4904109, 4908206, 4912303, 4916400, 4920497,
  4924594, 4928691, 4932788, 4934475, 4936885, 4940982, 4945079, 4949176,
  4953273, 4957370, 4961467, 4965564, 4969661, 4973758, 4977855, 4981952,
  4986049, 4990146, 4994243, 4998340, 5000268, 5002437, 5006534, 5010631,
  5014728, 5018825, 5022922, 5027019, 5031116, 5035213, 5039310, 5043407,
  5047504, 5051601, 5055698, 5059795, 5063892, 5066061, 5067989, 5072086,
  5076183, 5080280, 5084377, 5088474, 5092571, 5096668, 5100765, 5104862,
  5108959, 5113056, 5117153, 5121250, 5125347, 5129444, 5131854, 5133541,
  5137638, 5141735, 5145832, 5149929, 5154026, 5158123, 5162220, 5166317,
  5170414, 5174511, 5178608, 5182705, 5186802, 5190899, 5194996, 5197647,
  5199093, 5203190, 5207287, 5211384, 5215481, 5219578, 5223675, 5227772,
  5231869, 5235966, 5240063, 5244160, 5248257, 5252354, 5256451, 5260548,
  5263440, 5264645, 5268742, 5272839, 5276936, 5281033, 5285130, 5289227,
  5293324, 5297421, 5301518, 5305615, 5309712, 5313809, 5317906, 5322003,
  5326100, 5329233, 5330197, 5334294, 5338391, 5342488, 5346585, 5350682,
  5354779, 5358876, 5362973, 5367070, 5371167, 5375264, 5379361, 5383458,
  5387555, 5391652, 5395026, 5395749, 5399846, 5403943, 5408040, 5412137,
  5416234, 5420331, 5424428, 5428525, 5432622, 5436719, 5440816, 5444913,
  5449010, 5453107, 5457204, 5460819, 5461301, 5465398, 5469495, 5473592,
  5477689, 5481786, 5485883, 5489980, 5494077, 5498174, 5502271, 5506368,
  5510465, 5514562, 5518659, 5522756, 5526612, 5526853, 5530950, 5535047,
  5539144, 5543241, 5547338, 5551435, 5555532, 5559629, 5563726, 5567823,
  5571920, 5576017, 5580114, 5584211, 5588308, 5592405, 5596502, 5600599,
  5604696, 5608793, 5612890, 5616987, 5621084, 5625181, 5629278, 5633375,
  5637472, 5641569, 5645666, 5649763, 5653860, 5657957, 5658198, 5662054,
  5666151, 5670248, 5674345, 5678442, 5682539, 5686636, 5690733, 5694830,
  5698927, 5703024, 5707121, 5711218, 5715315, 5719412, 5723509, 5723991,
  5727606, 5731703, 5735800, 5739897, 5743994, 5748091, 5752188, 5756285,
  5760382, 5764479, 5768576, 5772673, 5776770, 5780867, 5784964, 5789061,
  5789784, 5793158, 5797255, 5801352, 5805449, 5809546, 5813643, 5817740,
  5821837, 5825934, 5830031, 5834128, 5838225, 5842322, 5846419, 5850516,
  5854613, 5855577, 5858710, 5862807, 5866904, 5871001, 5875098, 5879195,
  5883292, 5887389, 5891486, 5895583, 5899680, 5903777, 5907874, 5911971,
  5916068, 5920165, 5921370, 5924262, 5928359, 5932456, 5936553, 5940650,
  5944747, 5948844, 5952941, 5957038, 5961135, 5965232, 5969329, 5973426,
  5977523, 5981620, 5985717, 5987163, 5989814, 5993911, 5998008, 6002105,
  6006202, 6010299, 6014396, 6018493, 6022590, 6026687, 6030784, 6034881,
  6038978, 6043075, 6047172, 6051269, 6052956, 6055366, 6059463, 6063560,
  6067657, 6071754, 6075851, 6079948, 6084045, 6088142, 6092239, 6096336,
  6100433, 6104530, 6108627, 6112724, 6116821, 6118749, 6120918, 6125015,
  6129112, 6133209, 6137306, 6141403, 6145500, 6149597, 6153694, 6157791,
  6161888, 6165985, 6170082, 6174179, 6178276, 6182373, 6184542, 6186470,
  6190567, 6194664, 6198761, 6202858, 6206955, 6211052, 6215149, 6219246,
  6223343, 6227440, 6231537, 6235634, 6239731, 6243828, 6247925, 6250335,
  6252022, 6256119, 6260216, 6264313, 6268410, 6272507, 6276604, 6280701,
  6284798, 6288895, 6292992, 6297089, 6301186, 6305283, 6309380, 6313477,
  6316128, 6317574, 6321671, 6325768, 6329865, 6333962, 6338059, 6342156,
  6346253, 6350350, 6354447, 6358544, 6362641, 6366738, 6370835, 6374932,
  6379029, 6381921, 6383126, 6387223, 6391320, 6395417, 6399514, 6403611,
  6407708, 6411805, 6415902, 6419999, 6424096, 6428193, 6432290, 6436387,
  6440484, 6444581, 6447714, 6448678, 6452775, 6456872, 6460969, 6465066,
  6469163, 6473260, 6477357, 6481454, 6485551, 6489648, 6493745, 6497842,
  6501939, 6506036, 6510133, 6513507, 6514230, 6518327, 6522424, 6526521,
  6530618, 6534715, 6538812, 6542909, 6547006, 6551103, 6555200, 6559297,
  6563394, 6567491, 6571588, 6575685, 6579300, 6579782, 6583879, 6587976,
  6592073, 6596170, 6600267, 6604364, 6608461, 6612558, 6616655, 6620752,
  6624849, 6628946, 6633043, 6637140, 6641237, 6645093, 6645334, 6649431,
  6653528, 6657625, 6661722, 6665819, 6669916, 6674013, 6678110, 6682207,
  6686304, 6690401, 6694498, 6698595, 6702692, 6706789, 6710886, 6714983,
  6719080, 6723177, 6727274, 6731371, 6735468, 6739565, 6743662, 6747759,
  6751856, 6755953, 6760050, 6764147, 6768244, 6772341, 6776438, 6776679,
  6780535, 6784632, 6788729, 6792826, 6796923, 6801020, 6805117, 6809214,
  6813311, 6817408, 6821505, 6825602, 6829699, 6833796, 6837893, 6841990,
  6842472, 6846087, 6850184, 6854281, 6858378, 6862475, 6866572, 6870669,
  6874766, 6878863, 6882960, 6887057, 6891154, 6895251, 6899348, 6903445,
  6907542, 6908265, 6911639, 6915736, 6919833, 6923930, 6928027, 6932124,
  6936221, 6940318, 6944415, 6948512, 6952609, 6956706, 6960803, 6964900,
  6968997, 6973094, 6974058, 6977191, 6981288, 6985385, 6989482, 6993579,
  6997676, 7001773, 7005870, 7009967, 7014064, 7018161, 7022258, 7026355,
  7030452, 7034549, 7038646, 7039851, 7042743, 7046840, 7050937, 7055034,
  7059131, 7063228, 7067325, 7071422, 7075519, 7079616, 7083713, 7087810,
  7091907, 7096004, 7100101, 7104198, 7105644, 7108295, 7112392, 7116489,
  7120586, 7124683, 7128780, 7132877, 7136974, 7141071, 7145168, 7149265,
  7153362, 7157459, 7161556, 7165653, 7169750, 7171437, 7173847, 7177944,
  7182041, 7186138, 7190235, 7194332, 7198429, 7202526, 7206623, 7210720,
  7214817, 7218914, 7223011, 7227108, 7231205, 7235302, 7237230, 7239399,
  7243496, 7247593, 7251690, 7255787, 7259884, 7263981, 7268078, 7272175,
  7276272, 7280369, 7284466, 7288563, 7292660, 7296757, 7300854, 7303023,
  7304951, 7309048, 7313145, 7317242, 7321339, 7325436, 7329533, 7333630,
  7337727, 7341824, 7345921, 7350018, 7354115, 7358212, 7362309, 7366406,
  7368816, 7370503, 7374600, 7378697, 7382794, 7386891, 7390988, 7395085,
  7399182, 7403279, 7407376, 7411473, 7415570, 7419667, 7423764, 7427861,
  7431958, 7434609, 7436055, 7440152, 7444249, 7448346, 7452443, 7456540,
  7460637, 7464734, 7468831, 7472928, 7477025, 7481122, 7485219, 7489316,
  7493413, 7497510, 7500402, 7501607, 7505704, 7509801, 7513898, 7517995,
  7522092, 7526189, 7530286, 7534383, 7538480, 7542577, 7546674, 7550771,
  7554868, 7558965, 7563062, 7566195, 7567159, 7571256, 7575353, 7579450,
  7583547, 7587644, 7591741, 7595838, 7599935, 7604032, 7608129, 7612226,
  7616323, 7620420, 7624517, 7628614, 7631988, 7632711, 7636808, 7640905,
  7645002, 7649099, 7653196, 7657293, 7661390, 7665487, 7669584, 7673681,
  7677778, 7681875, 7685972, 7690069, 7694166, 7697781, 7698263, 7702360,
  7706457, 7710554, 7714651, 7718748, 7722845, 7726942, 7731039, 7735136,
  7739233, 7743330, 7747427, 7751524, 7755621, 7759718, 7763574, 7763815,
  7767912, 7772009, 7776106, 7780203, 7784300, 7788397, 7792494, 7796591,
  7800688, 7804785, 7808882, 7812979, 7817076, 7821173, 7825270, 7829367,
  7833464, 7837561, 7841658, 7845755, 7849852, 7853949, 7858046, 7862143,
  7866240, 7870337, 7874434, 7878531, 7882628, 7886725, 7890822, 7894919,
  7895160, 7899016, 7903113, 7907210, 7911307, 7915404, 7919501, 7923598,
  7927695, 7931792, 7935889, 7939986, 7944083, 7948180, 7952277, 7956374,
  7960471, 7960953, 7964568, 7968665, 7972762, 7976859, 7980956, 7985053,
  7989150, 7993247, 7997344, 8001441, 8005538, 8009635, 8013732, 8017829,
  8021926, 8026023, 8026746, 8030120, 8034217, 8038314, 8042411, 8046508,
  8050605, 8054702, 8058799, 8062896, 8066993, 8071090, 8075187, 8079284,
  8083381, 8087478, 8091575, 8092539, 8095672, 8099769, 8103866, 8107963,
  8112060, 8116157, 8120254, 8124351, 8128448, 8132545, 8136642, 8140739,
  8144836, 8148933, 8153030, 8157127, 8158332, 8161224, 8165321, 8169418,
  8173515, 8177612, 8181709, 8185806, 8189903, 8194000, 8198097, 8202194,
  8206291, 8210388, 8214485, 8218582, 8222679, 8224125, 8226776, 8230873,
  8234970, 8239067, 8243164, 8247261, 8251358, 8255455, 8259552, 8263649,
  8267746, 8271843, 8275940, 8280037, 8284134, 8288231, 8289918, 8292328,
  8296425, 8300522, 8304619, 8308716, 8312813, 8316910, 8321007, 8325104,
  8329201, 8333298, 8337395, 8341492, 8345589, 8349686, 8353783, 8355711,
  8357880, 8361977, 8366074, 8370171, 8374268, 8378365, 8382462, 8386559,
  8390656, 8394753, 8398850, 8402947, 8407044, 8411141, 8415238, 8419335,
  8421504, 8423432, 8427529, 8431626, 8435723, 8439820, 8443917, 8448014,
  8452111, 8456208, 8460305, 8464402, 8468499, 8472596, 8476693, 8480790,
  8484887, 8487297, 8488984, 8493081, 8497178, 8501275, 8505372, 8509469,
  8513566, 8517663, 8521760, 8525857, 8529954, 8534051, 8538148, 8542245,
  8546342, 8550439, 8553090, 8554536, 8558633, 8562730, 8566827, 8570924,
  8575021, 8579118, 8583215, 8587312, 8591409, 8595506, 8599603, 8603700,
  8607797, 8611894, 8615991, 8618883, 8620088, 8624185, 8628282, 8632379,
  8636476, 8640573, 8644670, 8648767, 8652864, 8656961, 8661058, 8665155,
  8669252, 8673349, 8677446, 8681543, 8684676, 8685640, 8689737, 8693834,
  8697931, 8702028, 8706125, 8710222, 8714319, 8718416, 8722513, 8726610,
  8730707, 8734804, 8738901, 8742998, 8747095, 8750469, 8751192, 8755289,
  8759386, 8763483, 8767580, 8771677, 8775774, 8779871, 8783968, 8788065,
  8792162, 8796259, 8800356, 8804453, 8808550, 8812647, 8816262, 8816744,
  8820841, 8824938, 8829035, 8833132, 8837229, 8841326, 8845423, 8849520,
  8853617, 8857714, 8861811, 8865908, 8870005, 8874102, 8878199, 8882055,
  8882296, 8886393, 8890490, 8894587, 8898684, 8902781, 8906878, 8910975,
  8915072, 8919169, 8923266, 8927363, 8931460, 8935557, 8939654, 8943751,
  8947848, 8951945, 8956042, 8960139, 8964236, 8968333, 8972430, 8976527,
  8980624, 8984721, 8988818, 8992915, 8997012, 9001109, 9005206, 9009303,
  9013400, 9013641, 9017497, 9021594, 9025691, 9029788, 9033885, 9037982,
  9042079, 9046176, 9050273, 9054370, 9058467, 9062564, 9066661, 9070758,
  9074855, 9078952, 9079434, 9083049, 9087146, 9091243, 9095340, 9099437,
  9103534, 9107631, 9111728, 9115825, 9119922, 9124019, 9128116, 9132213,
  9136310, 9140407, 9144504, 9145227, 9148601, 9152698, 9156795, 9160892,
  9164989, 9169086, 9173183, 9177280, 9181377, 9185474, 9189571, 9193668,
  9197765, 9201862, 9205959, 9210056, 9211020, 9214153, 9218250, 9222347,
  9226444, 9230541, 9234638, 9238735, 9242832, 9246929, 9251026, 9255123,
  9259220, 9263317, 9267414, 9271511, 9275608, 9276813, 9279705, 9283802,
  9287899, 9291996, 9296093, 9300190, 9304287, 9308384, 9312481, 9316578,
  9320675, 9324772, 9328869, 9332966, 9337063, 9341160, 9342606, 9345257,
  9349354, 9353451, 9357548, 9361645, 9365742, 9369839, 9373936, 9378033,
  9382130, 9386227, 9390324, 9394421, 9398518, 9402615, 9406712, 9408399,
  9410809, 9414906, 9419003, 9423100, 9427197, 9431294, 9435391, 9439488,
  9443585, 9447682, 9451779, 9455876, 9459973, 9464070, 9468167, 9472264,
  9474192, 9476361, 9480458, 9484555, 9488652, 9492749, 9496846, 9500943,
  9505040, 9509137, 9513234, 9517331, 9521428, 9525525, 9529622, 9533719,
  9537816, 9539985, 9541913, 9546010, 9550107, 9554204, 9558301, 9562398,
  9566495, 9570592, 9574689, 9578786, 9582883, 9586980, 9591077, 9595174,
  9599271, 9603368, 9605778, 9607465, 9611562, 9615659, 9619756, 9623853,
  9627950, 9632047, 9636144, 9640241, 9644338, 9648435, 9652532, 9656629,
  9660726, 9664823, 9668920, 9671571, 9673017, 9677114, 9681211, 9685308,
  9689405, 9693502, 9697599, 9701696, 9705793, 9709890, 9713987, 9718084,
  9722181, 9726278, 9730375, 9734472, 9737364, 9738569, 9742666, 9746763,
  9750860, 9754957, 9759054, 9763151, 9767248, 9771345, 9775442, 9779539,
  9783636, 9787733, 9791830, 9795927, 9800024, 9803157, 9804121, 9808218,
  9812315, 9816412, 9820509, 9824606, 9828703, 9832800, 9836897, 9840994,
  9845091, 9849188, 9853285, 9857382, 9861479, 9865576, 9868950, 9869673,
  9873770, 9877867, 9881964, 9886061, 9890158, 9894255, 9898352, 9902449,
  9906546, 9910643, 9914740, 9918837, 9922934, 9927031, 9931128, 9934743,
  9935225, 9939322, 9943419, 9947516, 9951613, 9955710, 9959807, 9963904,
  9968001, 9972098, 9976195, 9980292, 9984389, 9988486, 9992583, 9996680,
 10000536,10000777,10004874,10008971,10013068,10017165,10021262,10025359,
 10029456,10033553,10037650,10041747,10045844,10049941,10054038,10058135,
 10062232,10066329,10070426,10074523,10078620,10082717,10086814,10090911,
 10095008,10099105,10103202,10107299,10111396,10115493,10119590,10123687,
 10127784,10131881,10132122,10135978,10140075,10144172,10148269,10152366,
 10156463,10160560,10164657,10168754,10172851,10176948,10181045,10185142,
 10189239,10193336,10197433,10197915,10201530,10205627,10209724,10213821,
 10217918,10222015,10226112,10230209,10234306,10238403,10242500,10246597,
 10250694,10254791,10258888,10262985,10263708,10267082,10271179,10275276,
 10279373,10283470,10287567,10291664,10295761,10299858,10303955,10308052,
 10312149,10316246,10320343,10324440,10328537,10329501,10332634,10336731,
 10340828,10344925,10349022,10353119,10357216,10361313,10365410,10369507,
 10373604,10377701,10381798,10385895,10389992,10394089,10395294,10398186,
 10402283,10406380,10410477,10414574,10418671,10422768,10426865,10430962,
 10435059,10439156,10443253,10447350,10451447,10455544,10459641,10461087,
 10463738,10467835,10471932,10476029,10480126,10484223,10488320,10492417,
 10496514,10500611,10504708,10508805,10512902,10516999,10521096,10525193,
 10526880,10529290,10533387,10537484,10541581,10545678,10549775,10553872,
 10557969,10562066,10566163,10570260,10574357,10578454,10582551,10586648,
 10590745,10592673,10594842,10598939,10603036,10607133,10611230,10615327,
 10619424,10623521,10627618,10631715,10635812,10639909,10644006,10648103,
 10652200,10656297,10658466,10660394,10664491,10668588,10672685,10676782,
 10680879,10684976,10689073,10693170,10697267,10701364,10705461,10709558,
 10713655,10717752,10721849,10724259,10725946,10730043,10734140,10738237,
 10742334,10746431,10750528,10754625,10758722,10762819,10766916,10771013,
 10775110,10779207,10783304,10787401,10790052,10791498,10795595,10799692,
 10803789,10807886,10811983,10816080,10820177,10824274,10828371,10832468,
 10836565,10840662,10844759,10848856,10852953,10855845,10857050,10861147,
 10865244,10869341,10873438,10877535,10881632,10885729,10889826,10893923,
 10898020,10902117,10906214,10910311,10914408,10918505,10921638,10922602,
 10926699,10930796,10934893,10938990,10943087,10947184,10951281,10955378,
 10959475,10963572,10967669,10971766,10975863,10979960,10984057,10987431,
 10988154,10992251,10996348,11000445,11004542,11008639,11012736,11016833,
 11020930,11025027,11029124,11033221,11037318,11041415,11045512,11049609,
 11053224,11053706,11057803,11061900,11065997,11070094,11074191,11078288,
 11082385,11086482,11090579,11094676,11098773,11102870,11106967,11111064,
 11115161,11119017,11119258,11123355,11127452,11131549,11135646,11139743,
 11143840,11147937,11152034,11156131,11160228,11164325,11168422,11172519,
 11176616,11180713,11184810,11188907,11193004,11197101,11201198,11205295,
 11209392,11213489,11217586,11221683,11225780,11229877,11233974,11238071,
 11242168,11246265,11250362,11250603,11254459,11258556,11262653,11266750,
 11270847,11274944,11279041,11283138,11287235,11291332,11295429,11299526,
 11303623,11307720,11311817,11315914,11316396,11320011,11324108,11328205,
 11332302,11336399,11340496,11344593,11348690,11352787,11356884,11360981,
 11365078,11369175,11373272,11377369,11381466,11382189,11385563,11389660,
 11393757,11397854,11401951,11406048,11410145,11414242,11418339,11422436,
 11426533,11430630,11434727,11438824,11442921,11447018,11447982,11451115,
 11455212,11459309,11463406,11467503,11471600,11475697,11479794,11483891,
 11487988,11492085,11496182,11500279,11504376,11508473,11512570,11513775,
 11516667,11520764,11524861,11528958,11533055,11537152,11541249,11545346,
 11549443,11553540,11557637,11561734,11565831,11569928,11574025,11578122,
 11579568,11582219,11586316,11590413,11594510,11598607,11602704,11606801,
 11610898,11614995,11619092,11623189,11627286,11631383,11635480,11639577,
 11643674,11645361,11647771,11651868,11655965,11660062,11664159,11668256,
 11672353,11676450,11680547,11684644,11688741,11692838,11696935,11701032,
 11705129,11709226,11711154,11713323,11717420,11721517,11725614,11729711,
 11733808,11737905,11742002,11746099,11750196,11754293,11758390,11762487,
 11766584,11770681,11774778,11776947,11778875,11782972,11787069,11791166,
 11795263,11799360,11803457,11807554,11811651,11815748,11819845,11823942,
 11828039,11832136,11836233,11840330,11842740,11844427,11848524,11852621,
 11856718,11860815,11864912,11869009,11873106,11877203,11881300,11885397,
 11889494,11893591,11897688,11901785,11905882,11908533,11909979,11914076,
 11918173,11922270,11926367,11930464,11934561,11938658,11942755,11946852,
 11950949,11955046,11959143,11963240,11967337,11971434,11974326,11975531,
 11979628,11983725,11987822,11991919,11996016,12000113,12004210,12008307,
 12012404,12016501,12020598,12024695,12028792,12032889,12036986,12040119,
 12041083,12045180,12049277,12053374,12057471,12061568,12065665,12069762,
 12073859,12077956,12082053,12086150,12090247,12094344,12098441,12102538,
 12105912,12106635,12110732,12114829,12118926,12123023,12127120,12131217,
 12135314,12139411,12143508,12147605,12151702,12155799,12159896,12163993,
 12168090,12171705,12172187,12176284,12180381,12184478,12188575,12192672,
 12196769,12200866,12204963,12209060,12213157,12217254,12221351,12225448,
 12229545,12233642,12237498,12237739,12241836,12245933,12250030,12254127,
 12258224,12262321,12266418,12270515,12274612,12278709,12282806,12286903,
 12291000,12295097,12299194,12303291,12307388,12311485,12315582,12319679,
 12323776,12327873,12331970,12336067,12340164,12344261,12348358,12352455,
 12356552,12360649,12364746,12368843,12369084,12372940,12377037,12381134,
 12385231,12389328,12393425,12397522,12401619,12405716,12409813,12413910,
 12418007,12422104,12426201,12430298,12434395,12434877,12438492,12442589,
 12446686,12450783,12454880,12458977,12463074,12467171,12471268,12475365,
 12479462,12483559,12487656,12491753,12495850,12499947,12500670,12504044,
 12508141,12512238,12516335,12520432,12524529,12528626,12532723,12536820,
 12540917,12545014,12549111,12553208,12557305,12561402,12565499,12566463,
 12569596,12573693,12577790,12581887,12585984,12590081,12594178,12598275,
 12602372,12606469,12610566,12614663,12618760,12622857,12626954,12631051,
 12632256,12635148,12639245,12643342,12647439,12651536,12655633,12659730,
 12663827,12667924,12672021,12676118,12680215,12684312,12688409,12692506,
 12696603,12698049,12700700,12704797,12708894,12712991,12717088,12721185,
 12725282,12729379,12733476,12737573,12741670,12745767,12749864,12753961,
 12758058,12762155,12763842,12766252,12770349,12774446,12778543,12782640,
 12786737,12790834,12794931,12799028,12803125,12807222,12811319,12815416,
 12819513,12823610,12827707,12829635,12831804,12835901,12839998,12844095,
 12848192,12852289,12856386,12860483,12864580,12868677,12872774,12876871,
 12880968,12885065,12889162,12893259,12895428,12897356,12901453,12905550,
 12909647,12913744,12917841,12921938,12926035,12930132,12934229,12938326,
 12942423,12946520,12950617,12954714,12958811,12961221,12962908,12967005,
 12971102,12975199,12979296,12983393,12987490,12991587,12995684,12999781,
 13003878,13007975,13012072,13016169,13020266,13024363,13027014,13028460,
 13032557,13036654,13040751,13044848,13048945,13053042,13057139,13061236,
 13065333,13069430,13073527,13077624,13081721,13085818,13089915,13092807,
 13094012,13098109,13102206,13106303,13110400,13114497,13118594,13122691,
 13126788,13130885,13134982,13139079,13143176,13147273,13151370,13155467,
 13158600,13159564,13163661,13167758,13171855,13175952,13180049,13184146,
 13188243,13192340,13196437,13200534,13204631,13208728,13212825,13216922,
 13221019,13224393,13225116,13229213,13233310,13237407,13241504,13245601,
 13249698,13253795,13257892,13261989,13266086,13270183,13274280,13278377,
 13282474,13286571,13290186,13290668,13294765,13298862,13302959,13307056,
 13311153,13315250,13319347,13323444,13327541,13331638,13335735,13339832,
 13343929,13348026,13352123,13355979,13356220,13360317,13364414,13368511,
 13372608,13376705,13380802,13384899,13388996,13393093,13397190,13401287,
 13405384,13409481,13413578,13417675,13421772,13425869,13429966,13434063,
 13438160,13442257,13446354,13450451,13454548,13458645,13462742,13466839,
 13470936,13475033,13479130,13483227,13487324,13487565,13491421,13495518,
 13499615,13503712,13507809,13511906,13516003,13520100,13524197,13528294,
 13532391,13536488,13540585,13544682,13548779,13552876,13553358,13556973,
 13561070,13565167,13569264,13573361,13577458,13581555,13585652,13589749,
 13593846,13597943,13602040,13606137,13610234,13614331,13618428,13619151,
 13622525,13626622,13630719,13634816,13638913,13643010,13647107,13651204,
 13655301,13659398,13663495,13667592,13671689,13675786,13679883,13683980,
 13684944,13688077,13692174,13696271,13700368,13704465,13708562,13712659,
 13716756,13720853,13724950,13729047,13733144,13737241,13741338,13745435,
 13749532,13750737,13753629,13757726,13761823,13765920,13770017,13774114,
 13778211,13782308,13786405,13790502,13794599,13798696,13802793,13806890,
 13810987,13815084,13816530,13819181,13823278,13827375,13831472,13835569,
 13839666,13843763,13847860,13851957,13856054,13860151,13864248,13868345,
 13872442,13876539,13880636,13882323,13884733,13888830,13892927,13897024,
 13901121,13905218,13909315,13913412,13917509,13921606,13925703,13929800,
 13933897,13937994,13942091,13946188,13948116,13950285,13954382,13958479,
 13962576,13966673,13970770,13974867,13978964,13983061,13987158,13991255,
 13995352,13999449,14003546,14007643,14011740,14013909,14015837,14019934,
 14024031,14028128,14032225,14036322,14040419,14044516,14048613,14052710,
 14056807,14060904,14065001,14069098,14073195,14077292,14079702,14081389,
 14085486,14089583,14093680,14097777,14101874,14105971,14110068,14114165,
 14118262,14122359,14126456,14130553,14134650,14138747,14142844,14145495,
 14146941,14151038,14155135,14159232,14163329,14167426,14171523,14175620,
 14179717,14183814,14187911,14192008,14196105,14200202,14204299,14208396,
 14211288,14212493,14216590,14220687,14224784,14228881,14232978,14237075,
 14241172,14245269,14249366,14253463,14257560,14261657,14265754,14269851,
 14273948,14277081,14278045,14282142,14286239,14290336,14294433,14298530,
 14302627,14306724,14310821,14314918,14319015,14323112,14327209,14331306,
 14335403,14339500,14342874,14343597,14347694,14351791,14355888,14359985,
 14364082,14368179,14372276,14376373,14380470,14384567,14388664,14392761,
 14396858,14400955,14405052,14408667,14409149,14413246,14417343,14421440,
 14425537,14429634,14433731,14437828,14441925,14446022,14450119,14454216,
 14458313,14462410,14466507,14470604,14474460,14474701,14478798,14482895,
 14486992,14491089,14495186,14499283,14503380,14507477,14511574,14515671,
 14519768,14523865,14527962,14532059,14536156,14540253,14544350,14548447,
 14552544,14556641,14560738,14564835,14568932,14573029,14577126,14581223,
 14585320,14589417,14593514,14597611,14601708,14605805,14606046,14609902,
 14613999,14618096,14622193,14626290,14630387,14634484,14638581,14642678,
 14646775,14650872,14654969,14659066,14663163,14667260,14671357,14671839,
 14675454,14679551,14683648,14687745,14691842,14695939,14700036,14704133,
 14708230,14712327,14716424,14720521,14724618,14728715,14732812,14736909,
 14737632,14741006,14745103,14749200,14753297,14757394,14761491,14765588,
 14769685,14773782,14777879,14781976,14786073,14790170,14794267,14798364,
 14802461,14803425,14806558,14810655,14814752,14818849,14822946,14827043,
 14831140,14835237,14839334,14843431,14847528,14851625,14855722,14859819,
 14863916,14868013,14869218,14872110,14876207,14880304,14884401,14888498,
 14892595,14896692,14900789,14904886,14908983,14913080,14917177,14921274,
 14925371,14929468,14933565,14935011,14937662,14941759,14945856,14949953,
 14954050,14958147,14962244,14966341,14970438,14974535,14978632,14982729,
 14986826,14990923,14995020,14999117,15000804,15003214,15007311,15011408,
 15015505,15019602,15023699,15027796,15031893,15035990,15040087,15044184,
 15048281,15052378,15056475,15060572,15064669,15066597,15068766,15072863,
 15076960,15081057,15085154,15089251,15093348,15097445,15101542,15105639,
 15109736,15113833,15117930,15122027,15126124,15130221,15132390,15134318,
 15138415,15142512,15146609,15150706,15154803,15158900,15162997,15167094,
 15171191,15175288,15179385,15183482,15187579,15191676,15195773,15198183,
 15199870,15203967,15208064,15212161,15216258,15220355,15224452,15228549,
 15232646,15236743,15240840,15244937,15249034,15253131,15257228,15261325,
 15263976,15265422,15269519,15273616,15277713,15281810,15285907,15290004,
 15294101,15298198,15302295,15306392,15310489,15314586,15318683,15322780,
 15326877,15329769,15330974,15335071,15339168,15343265,15347362,15351459,
 15355556,15359653,15363750,15367847,15371944,15376041,15380138,15384235,
 15388332,15392429,15395562,15396526,15400623,15404720,15408817,15412914,
 15417011,15421108,15425205,15429302,15433399,15437496,15441593,15445690,
 15449787,15453884,15457981,15461355,15462078,15466175,15470272,15474369,
 15478466,15482563,15486660,15490757,15494854,15498951,15503048,15507145,
 15511242,15515339,15519436,15523533,15527148,15527630,15531727,15535824,
 15539921,15544018,15548115,15552212,15556309,15560406,15564503,15568600,
 15572697,15576794,15580891,15584988,15589085,15592941,15593182,15597279,
 15601376,15605473,15609570,15613667,15617764,15621861,15625958,15630055,
 15634152,15638249,15642346,15646443,15650540,15654637,15658734,15662831,
 15666928,15671025,15675122,15679219,15683316,15687413,15691510,15695607,
 15699704,15703801,15707898,15711995,15716092,15720189,15724286,15724527,
 15728383,15732480,15736577,15740674,15744771,15748868,15752965,15757062,
 15761159,15765256,15769353,15773450,15777547,15781644,15785741,15789838,
 15790320,15793935,15798032,15802129,15806226,15810323,15814420,15818517,
 15822614,15826711,15830808,15834905,15839002,15843099,15847196,15851293,
 15855390,15856113,15859487,15863584,15867681,15871778,15875875,15879972,
 15884069,15888166,15892263,15896360,15900457,15904554,15908651,15912748,
 15916845,15920942,15921906,15925039,15929136,15933233,15937330,15941427,
 15945524,15949621,15953718,15957815,15961912,15966009,15970106,15974203,
 15978300,15982397,15986494,15987699,15990591,15994688,15998785,16002882,
 16006979,16011076,16015173,16019270,16023367,16027464,16031561,16035658,
 16039755,16043852,16047949,16052046,16053492,16056143,16060240,16064337,
 16068434,16072531,16076628,16080725,16084822,16088919,16093016,16097113,
 16101210,16105307,16109404,16113501,16117598,16119285,16121695,16125792,
 16129889,16133986,16138083,16142180,16146277,16150374,16154471,16158568,
 16162665,16166762,16170859,16174956,16179053,16183150,16185078,16187247,
 16191344,16195441,16199538,16203635,16207732,16211829,16215926,16220023,
 16224120,16228217,16232314,16236411,16240508,16244605,16248702,16250871,
 16252799,16256896,16260993,16265090,16269187,16273284,16277381,16281478,
 16285575,16289672,16293769,16297866,16301963,16306060,16310157,16314254,
 16316664,16318351,16322448,16326545,16330642,16334739,16338836,16342933,
 16347030,16351127,16355224,16359321,16363418,16367515,16371612,16375709,
 16379806,16382457,16383903,16388000,16392097,16396194,16400291,16404388,
 16408485,16412582,16416679,16420776,16424873,16428970,16433067,16437164,
 16441261,16445358,16448250,16449455,16453552,16457649,16461746,16465843,
 16469940,16474037,16478134,16482231,16486328,16490425,16494522,16498619,
 16502716,16506813,16510910,16514043,16515007,16519104,16523201,16527298,
 16531395,16535492,16539589,16543686,16547783,16551880,16555977,16560074,
 16564171,16568268,16572365,16576462,16579836,16580559,16584656,16588753,
 16592850,16596947,16601044,16605141,16609238,16613335,16617432,16621529,
 16625626,16629723,16633820,16637917,16642014,16645629,16646111,16650208,
 16654305,16658402,16662499,16666596,16670693,16674790,16678887,16682984,
 16687081,16691178,16695275,16699372,16703469,16707566,16711422,16711663,
 16715760,16719857,16723954,16728051,16732148,16736245,16740342,16744439,
 16748536,16752633,16756730,16760827,16764924,16769021,16773118,16777215,
}; 
#endif


static int oligosize;
static Storedoligomer_T *repetitive_oligos;

void
Oligo_setup (int index1part) {
  oligosize = index1part;

  if (index1part == 6) {
    repetitive_oligos = repetitive_oligos_6;
  } else if (index1part == 7) {
    repetitive_oligos = repetitive_oligos_7;
  } else if (index1part == 8) {
    repetitive_oligos = repetitive_oligos_8;
  } else if (index1part == 9) {
    repetitive_oligos = repetitive_oligos_9;
  } else if (index1part == 10) {
    repetitive_oligos = repetitive_oligos_10;
  } else if (index1part == 11) {
    repetitive_oligos = repetitive_oligos_11;
  } else if (index1part == 12) {
    repetitive_oligos = repetitive_oligos_12;
  } else if (index1part == 13) {
    repetitive_oligos = repetitive_oligos_13;
  } else if (index1part == 14) {
    repetitive_oligos = repetitive_oligos_14;
  } else if (index1part == 15) {
    repetitive_oligos = repetitive_oligos_15;
  } else if (index1part == 16) {
    repetitive_oligos = repetitive_oligos_16;
  } else {
    fprintf(stderr,"Oligo_setup can handle only values of 6 through 16\n");
    abort();
  }
  return;
}


/*               87654321 */
#define LEFT_A 0x00000000
#define LEFT_C 0x40000000
#define LEFT_G 0x80000000
#define LEFT_T 0xC0000000

/*                87654321 */
#define RIGHT_A 0x00000000
#define RIGHT_C 0x00000001
#define RIGHT_G 0x00000002
#define RIGHT_T 0x00000003


/*               87654321 */
#define LEFT_0 0x00000000
#define LEFT_1 0x40000000
#define LEFT_2 0x80000000
#define LEFT_3 0xC0000000

/*                87654321 */
#define RIGHT_0 0x00000000
#define RIGHT_1 0x00000001
#define RIGHT_2 0x00000002
#define RIGHT_3 0x00000003


/************************************************************************
 *   Check
 ************************************************************************/

/*                      87654321 */
#define LOW_TWO_BITS  0x00000003

/* For debugging purposes only */
char *
Oligo_one_nt (Storedoligomer_T oligo, int oligosize) {
  char *nt;
  int i, j;
  Storedoligomer_T lowbits;

  nt = (char *) CALLOC(oligosize+1,sizeof(char));
  j = oligosize-1;
  for (i = 0; i < oligosize; i++) {
    lowbits = oligo & LOW_TWO_BITS;
    switch (lowbits) {
    case RIGHT_A: nt[j] = 'A'; break;
    case RIGHT_C: nt[j] = 'C'; break;
    case RIGHT_G: nt[j] = 'G'; break;
    case RIGHT_T: nt[j] = 'T'; break;
    }
    oligo >>= 2;
    j--;
  }

  return nt;
}

/* This procedure is called only by GMAP.  If characters are pushed
   onto left end, oligo will need to be shifted beforehand.  Note:
   positions is allocated by system malloc() */
/* No longer seems to be called by GMAP either */
int
Oligo_lookup (Univcoord_T **positions, Indexdb_T indexdb, Storedoligomer_T storedoligo) {
  int nentries;
  debug(char *nt);
  debug1(int i);
  
  debug(nt = Oligo_one_nt(storedoligo,16);
	printf("Oligo on entry = %06X (%s)",storedoligo,nt);
	FREE(nt);
	);
  
  if ((*positions = Indexdb_read(&nentries,indexdb,storedoligo)) == NULL) {
    debug(printf(" not found\n"));
    return 0;
    
  } else {
    debug(printf(" => %d entries: ",nentries));
    debug1(
	   for (i = 0; i < nentries; i++) {
	     printf("%u ",(*positions)[i]);
	   }
	   printf("\n");
	   );
    debug(printf("\n"));
    return nentries;
  }
}

static Oligostate_T
oligo_read (int *querypos, Storedoligomer_T *forward, Storedoligomer_T *revcomp, 
	    Reader_T reader, cDNAEnd_T cdnaend) {
  int count = 0;
  int c;

  *forward = *revcomp = 0U;
  if (cdnaend == FIVE) {
    while (count < oligosize && (c = Reader_getc(reader,cdnaend)) != '\0') {
      switch (c) {
      case 'A': *forward <<= 2; *revcomp >>= 2; *revcomp |= LEFT_T; break;
      case 'C': *forward <<= 2; *forward |= RIGHT_C; 
	*revcomp >>= 2; *revcomp |= LEFT_G;  break;
      case 'G': *forward <<= 2; *forward |= RIGHT_G;
	*revcomp >>= 2; *revcomp |= LEFT_C; break;
      case 'T': *forward <<= 2; *forward |= RIGHT_T; *revcomp >>= 2; break;
      default: *forward = *revcomp = 0U; count = -1; 
	/* This counteracts count++ below */
      }
      count++;
      debug(printf("5' Read %c, count = %d, oligo = %06X, %06X\n",
		   c,count,*forward,*revcomp));
    }
  } else {
    while (count < oligosize && (c = Reader_getc(reader,cdnaend)) != '\0') {
      switch (c) {
      case 'A': *forward >>= 2; *revcomp <<= 2; *revcomp |= RIGHT_T; break;
      case 'C': *forward >>= 2; *forward |= LEFT_C; 
	*revcomp <<= 2; *revcomp |= RIGHT_G;  break;
      case 'G': *forward >>= 2; *forward |= LEFT_G;
	*revcomp <<= 2; *revcomp |= RIGHT_C; break;
      case 'T': *forward >>= 2; *forward |= LEFT_T; *revcomp <<= 2; break;
      default: *forward = *revcomp = 0U; count = -1; 
	/* This counteracts count++ below */
      }
      count++;
      debug(printf("3' Read %c, count = %d, oligo = %06X, %06X\n",
		   c,count,*forward,*revcomp));
    }
  }

  if (count < oligosize) {
    *forward = *revcomp = 0U;
    return DONE;
  } else {
    debug(printf("Read: Returning oligo %06X for count = %d and size = %d\n",
		  *forward,count,oligosize));
    if (cdnaend == FIVE) {
      *querypos = Reader_startpos(reader) - oligosize;
      debug(printf("Setting querypos to be %u - %u = %u\n",
		   Reader_startpos(reader),oligosize,*querypos));
    } else {
      *querypos = Reader_endpos(reader) + 1;
      debug(printf("Setting querypos to be %u + 1 = %u\n",
		   Reader_endpos(reader),*querypos));
    }
    return VALID;
  }
}


#if 0
static Oligostate_T
oligo_read_dibase (int *querypos, Storedoligomer_T *forward, Storedoligomer_T *revcomp, 
		   Reader_T reader, cDNAEnd_T cdnaend) {
  int count = 0;
  int c;

  *forward = *revcomp = 0U;
  if (cdnaend == FIVE) {
    while (count < oligosize && (c = Reader_getc(reader,cdnaend)) != '\0') {
      switch (c) {
      case '0': *forward <<= 2; *revcomp >>= 2; break;
      case '1': *forward <<= 2; *forward |= RIGHT_1; 
	*revcomp >>= 2; *revcomp |= LEFT_1;  break;
      case '2': *forward <<= 2; *forward |= RIGHT_2;
	*revcomp >>= 2; *revcomp |= LEFT_2; break;
      case '3': *forward <<= 2; *forward |= RIGHT_3;
	*revcomp >>= 2; *revcomp |= LEFT_3; break;
      default: *forward = *revcomp = 0U; count = -1; 
	/* This counteracts count++ below */
      }
      count++;
      debug(printf("5' Read %c, count = %d, oligo = %06X, %06X\n",
		   c,count,*forward,*revcomp));
    }
  } else {
    while (count < oligosize && (c = Reader_getc(reader,cdnaend)) != '\0') {
      switch (c) {
      case '0': *forward >>= 2; *revcomp <<= 2; break;
      case '1': *forward >>= 2; *forward |= LEFT_1; 
	*revcomp <<= 2; *revcomp |= RIGHT_1;  break;
      case '2': *forward >>= 2; *forward |= LEFT_2;
	*revcomp <<= 2; *revcomp |= RIGHT_2; break;
      case '3': *forward >>= 2; *forward |= LEFT_3;
	*revcomp <<= 2; *revcomp |= RIGHT_3; break;
      default: *forward = *revcomp = 0U; count = -1; 
	/* This counteracts count++ below */
      }
      count++;
      debug(printf("3' Read %c, count = %d, oligo = %06X, %06X\n",
		   c,count,*forward,*revcomp));
    }
  }

  if (count < oligosize) {
    *forward = *revcomp = 0U;
    return DONE;
  } else {
    debug(printf("Read: Returning oligo %06X for count = %d and size = %d\n",
		  *forward,count,oligosize));
    if (cdnaend == FIVE) {
      *querypos = Reader_startpos(reader) - oligosize;
      debug(printf("Setting querypos to be %u - %u = %u\n",
		   Reader_startpos(reader),oligosize,*querypos));
    } else {
      *querypos = Reader_endpos(reader) + 1;
      debug(printf("Setting querypos to be %u + 1 = %u\n",
		   Reader_endpos(reader),*querypos));
    }
    return VALID;
  }
}
#endif


#if 0
typedef Oligostate_T (*oligo_read_proc_t) (int *, Storedoligomer_T *, Storedoligomer_T *,
					   int, Reader_T, cDNAEnd_T);
static oligo_read_proc_t oligo_read;
#endif



static Oligostate_T
oligo_revise (int *querypos, Storedoligomer_T *forward, Storedoligomer_T *revcomp, 
	      Reader_T reader, cDNAEnd_T cdnaend) {
  char c;

  if ((c = Reader_getc(reader,cdnaend)) == '\0') {
    *forward = *revcomp = 0U;
    debug(
	  if (cdnaend == FIVE) {
	    printf("5' Revision: read terminating char %c\n",c);
	  } else {
	    printf("3' Revision: read terminating char %c\n",c);
	  }
	  );
    return DONE;

  } else if (cdnaend == FIVE) {
    switch (c) {
    case 'A': *forward <<= 2; *revcomp >>= 2; *revcomp |= LEFT_T; break;
    case 'C': *forward <<= 2; *forward |= RIGHT_C; 
      *revcomp >>= 2; *revcomp |= LEFT_G; break;
    case 'G': *forward <<= 2; *forward |= RIGHT_G;
      *revcomp >>= 2; *revcomp |= LEFT_C; break;
    case 'T': *forward <<= 2; *forward |= RIGHT_T; *revcomp >>= 2; break;
    default: *forward = *revcomp = 0U; 
      *querypos = Reader_startpos(reader) - oligosize;
      return INVALID;
    }

    *querypos = Reader_startpos(reader) - oligosize;
    debug(printf("5' Revision: read char %c, oligo = %06X, %06X at querypos %d\n",
		 c,*forward,*revcomp,*querypos));
    return VALID;

  } else {
    switch (c) {
    case 'A': *forward >>= 2; *revcomp <<= 2; *revcomp |= RIGHT_T; break;
    case 'C': *forward >>= 2; *forward |= LEFT_C; 
      *revcomp <<= 2; *revcomp |= RIGHT_G; break;
    case 'G': *forward >>= 2; *forward |= LEFT_G;
      *revcomp <<= 2; *revcomp |= RIGHT_C; break;
    case 'T': *forward >>= 2; *forward |= LEFT_T; *revcomp <<= 2; break;
    default: *forward = *revcomp = 0U; 
      *querypos = Reader_endpos(reader) + 1;
      return INVALID;
    }

    *querypos = Reader_endpos(reader) + 1;
    debug(printf("3' Revision: read char %c, oligo = %06X, %06X at querypos %d\n",
		 c,*forward,*revcomp,*querypos));
    return VALID;
  }
}


#if 0
static Oligostate_T
oligo_revise_dibase (int *querypos, Storedoligomer_T *forward, Storedoligomer_T *revcomp, 
		     Reader_T reader, cDNAEnd_T cdnaend) {
  char c;

  if ((c = Reader_getc(reader,cdnaend)) == '\0') {
    *forward = *revcomp = 0U;
    debug(
	  if (cdnaend == FIVE) {
	    printf("5' Revision: read terminating char %c\n",c);
	  } else {
	    printf("3' Revision: read terminating char %c\n",c);
	  }
	  );
    return DONE;

  } else if (cdnaend == FIVE) {
    switch (c) {
    case '0': *forward <<= 2; *revcomp >>= 2; break;
    case '1': *forward <<= 2; *forward |= RIGHT_1; 
      *revcomp >>= 2; *revcomp |= LEFT_1; break;
    case '2': *forward <<= 2; *forward |= RIGHT_2;
      *revcomp >>= 2; *revcomp |= LEFT_2; break;
    case '3': *forward <<= 2; *forward |= RIGHT_3;
      *revcomp >>= 2; *revcomp |= LEFT_3; break;
    default: *forward = *revcomp = 0U; 
      *querypos = Reader_startpos(reader) - oligosize;
      return INVALID;
    }

    *querypos = Reader_startpos(reader) - oligosize;
    debug(printf("5' Revision: read char %c, oligo = %06X, %06X at querypos %d\n",
		 c,*forward,*revcomp,*querypos));
    return VALID;

  } else {
    switch (c) {
    case '0': *forward >>= 2; *revcomp <<= 2; break;
    case '1': *forward >>= 2; *forward |= LEFT_1; 
      *revcomp <<= 2; *revcomp |= RIGHT_1; break;
    case '2': *forward >>= 2; *forward |= LEFT_2;
      *revcomp <<= 2; *revcomp |= RIGHT_2; break;
    case '3': *forward >>= 2; *forward |= LEFT_3;
      *revcomp <<= 2; *revcomp |= RIGHT_3; break;
    default: *forward = *revcomp = 0U; 
      *querypos = Reader_endpos(reader) + 1;
      return INVALID;
    }

    *querypos = Reader_endpos(reader) + 1;
    debug(printf("3' Revision: read char %c, oligo = %06X, %06X at querypos %d\n",
		 c,*forward,*revcomp,*querypos));
    return VALID;
  }
}
#endif

#if 0
typedef Oligostate_T (*oligo_revise_proc_t) (int *, Storedoligomer_T *, Storedoligomer_T *,
					     int, Reader_T, cDNAEnd_T);
static oligo_revise_proc_t oligo_revise;
#endif



Oligostate_T
Oligo_next (Oligostate_T last_state, int *querypos, Storedoligomer_T *forward,
	    Storedoligomer_T *revcomp, Reader_T reader, cDNAEnd_T cdnaend) {
  Oligostate_T state;

  if (last_state == DONE) {
    fprintf(stderr,"Called Oligo_next with last_state == DONE\n");
    exit(1);

  } else if (last_state == VALID) {
    if ((state = oligo_revise(&(*querypos),&(*forward),&(*revcomp),reader,cdnaend)) == DONE) {
      return DONE;
    } else if (state == VALID) {
      return VALID;
    } else {
      /* state == INVALID */
      return oligo_read(&(*querypos),&(*forward),&(*revcomp),reader,cdnaend);
    }

  } else {			/* INVALID and INIT */
    return oligo_read(&(*querypos),&(*forward),&(*revcomp),reader,cdnaend);
  }
}

Oligostate_T
Oligo_skip (Oligostate_T last_state, int *querypos, Storedoligomer_T *forward,
	    Storedoligomer_T *revcomp, Reader_T reader, cDNAEnd_T cdnaend, int nskip) {
  int i = 0;

  while (i < nskip && last_state != DONE) {
    if (last_state == VALID) {
      last_state = oligo_revise(&(*querypos),&(*forward),&(*revcomp),reader,cdnaend);
      i++;
    } else {			/* INVALID and INIT */
      last_state = oligo_read(&(*querypos),&(*forward),&(*revcomp),reader,cdnaend);
      i += oligosize;
    }
  }
  return last_state;
}


#if 0
/* Procedure used by oligo-count.c.  oligosize here is expected to be > 12.  */
char *
Oligo_nt (Storedoligomer_T oligo1, Storedoligomer_T oligo2, int oligosize, int index1part) {
  char *nt;
  int i, j;
  Storedoligomer_T lowbits;

  nt = (char *) CALLOC(oligosize+1,sizeof(char));
  j = oligosize-1;
  for (i = 0; i < oligosize - index1part; i++) {
    lowbits = oligo2 & LOW_TWO_BITS;
    switch (lowbits) {
    case RIGHT_A: nt[j] = 'A'; break;
    case RIGHT_C: nt[j] = 'C'; break;
    case RIGHT_G: nt[j] = 'G'; break;
    case RIGHT_T: nt[j] = 'T'; break;
    }
    oligo2 >>= 2;
    j--;
  }

  for (i = 0; i < index1part; i++) {
    lowbits = oligo1 & LOW_TWO_BITS;
    switch (lowbits) {
    case RIGHT_A: nt[j] = 'A'; break;
    case RIGHT_C: nt[j] = 'C'; break;
    case RIGHT_G: nt[j] = 'G'; break;
    case RIGHT_T: nt[j] = 'T'; break;
    }
    oligo1 >>= 2;
    j--;
  }

  return nt;
}
#endif


struct Cell_T {
  int querypos;
  Storedoligomer_T oligo;
};

/* Taken from oligo_hr.c */
static int
Cell_compare (const void *a, const void *b) {
  struct Cell_T x = * (struct Cell_T *) a;
  struct Cell_T y = * (struct Cell_T *) b;

  if (x.oligo < y.oligo) {
    return -1;
  } else if (y.oligo < x.oligo) {
    return +1;
  } else {
    return 0;
  }
}


#define BINARY_FOLDDIFF 16

static int
binary_search (int lowi, int highi, Storedoligomer_T *oligos, Storedoligomer_T goal) {
  bool foundp = false;
  int middlei;

  debug2(printf("entered binary search with lowi=%d, highi=%d, goal=%u\n",lowi,highi,goal));

  while (!foundp && lowi < highi) {
    middlei = (lowi+highi)/2;
    debug2(printf("  binary: %d:%u %d:%u %d:%u   vs. %u\n",
		   lowi,oligos[lowi],middlei,oligos[middlei],
		   highi,oligos[highi],goal));
    if (goal < oligos[middlei]) {
      highi = middlei;
    } else if (goal > oligos[middlei]) {
      lowi = middlei + 1;
    } else {
      foundp = true;
    }
  }

  if (foundp == true) {
    debug2(printf("binary search returns %d\n",middlei));
    return middlei;
  } else {
    debug2(printf("binary search returns %d\n",highi));
    return highi;
  }
}


#if 0
bool
Oligo_mark_repetitive (bool **repetitivep, Storedoligomer_T *oligos,
		       int first_querypos, int last_querypos) {
  bool any_repetitive_p = false;
  struct Cell_T *cells;
  int n, i, j, querypos, nremaining, binary_threshold;
  Storedoligomer_T *q;

  n = last_querypos - first_querypos + 1;
  cells = (struct Cell_T *) CALLOC(n,sizeof(struct Cell_T));
  for (i = 0, querypos = first_querypos; i < n; i++, querypos++) {
    cells[i].querypos = querypos;
    cells[i].oligo = oligos[querypos];
  }
  qsort(cells,n,sizeof(struct Cell_T),Cell_compare);

  q = &(repetitive_oligos[0]);
  nremaining = NREPETITIVE;
  binary_threshold = BINARY_FOLDDIFF * n;
  for (i = 0; i < n; i++) {
    debug2(printf("Testing if %u is repetitive\n",cells[i].oligo));
    if (nremaining < binary_threshold) {
      while (*q < cells[i].oligo) {
	q++;
	nremaining--;
      }
      debug2(printf("  advanced to oligo %u\n",*q));
    } else if (*q < cells[i].oligo) {
      j = binary_search(1,nremaining,q,cells[i].oligo);
      q += j;
      nremaining -= j;
    }

    if (*q == cells[i].oligo) {
      debug2(printf("  Yes it is (position %d)\n",cells[i].querypos));
      (*repetitivep)[cells[i].querypos] = true;
      any_repetitive_p = true;
    }
    binary_threshold -= BINARY_FOLDDIFF;
  }

  FREE(cells);
  return any_repetitive_p;
}
#endif


bool
Oligo_repetitive_p (Storedoligomer_T oligo) {
  int j;

  j = binary_search(0,NREPETITIVE,repetitive_oligos,oligo);
  if (repetitive_oligos[j] == oligo) {
    return true;
  } else {
    return false;
  }
}


#if 0
bool
Oligo_mark_frequent (bool **frequentp, Storedoligomer_T *oligos, int n,
		     Storedoligomer_T *frequent_oligos, int nfrequent) {
  bool any_frequent_p = false;
  struct Cell_T *cells;
  int i, j, nremaining, binary_threshold;
  Storedoligomer_T *q;

  cells = (struct Cell_T *) CALLOC(n,sizeof(struct Cell_T));
  for (i = 0; i < n; i++) {
    cells[i].querypos = i;
    cells[i].oligo = oligos[i];
  }
  qsort(cells,n,sizeof(struct Cell_T),Cell_compare);

  q = &(frequent_oligos[0]);
  nremaining = nfrequent;
  binary_threshold = BINARY_FOLDDIFF * n;
  for (i = 0; i < n; i++) {
    debug2(printf("Testing if %u is frequent\n",cells[i].oligo));
    if (nremaining < binary_threshold) {
      while (*q < cells[i].oligo) {
	q++;
	nremaining--;
      }
      debug2(printf("  advanced to oligo %u\n",*q));
    } else if (*q < cells[i].oligo) {
      j = binary_search(1,nremaining,q,cells[i].oligo);
      q += j;
      nremaining -= j;
    }

    if (*q == cells[i].oligo) {
      debug2(printf("  Yes it is (position %d)\n",cells[i].querypos));
      (*frequentp)[cells[i].querypos] = true;
      any_frequent_p = true;
    }
    binary_threshold -= BINARY_FOLDDIFF;
  }

  FREE(cells);
  return any_frequent_p;
}

Storedoligomer_T *
Oligo_frequent_oligos (int *nfrequent, Indexdb_T indexdb, int size_threshold) {
  Storedoligomer_T *frequent_oligos, oligo;
  int npositions, i, k;
  bool *frequentp;

  *nfrequent = 0;
  frequentp = (bool *) CALLOC(NREPETITIVE,sizeof(bool));
  for (i = 0; i < NREPETITIVE; i++) {
    oligo = all_repetitive_oligos[i];
    npositions = Indexdb_count_no_subst(indexdb,oligo);
    if (npositions > size_threshold) {
      frequentp[i] = true;
      (*nfrequent) += 1;
    }
  }

  /* Include poly-A and poly-T */
  if (frequentp[0] == false) {
    frequentp[0] = true;
    (*nfrequent) += 1;
  }
  if (frequentp[NREPETITIVE-1] == false) {
    frequentp[NREPETITIVE-1] = true;
    (*nfrequent) += 1;
  }

  frequent_oligos = (Storedoligomer_T *) CALLOC(*nfrequent,sizeof(Storedoligomer_T));
  k = 0;
  for (i = 0; i < NREPETITIVE; i++) {
    if (frequentp[i] == true) {
      frequent_oligos[k++] = all_repetitive_oligos[i];
    }
  }

  FREE(frequentp);
  return frequent_oligos;
}

#endif


