% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis.R
\name{hexpand}
\alias{hexpand}
\alias{vexpand}
\alias{ggexpand}
\title{hexpand}
\usage{
hexpand(ratio, direction = 1)

vexpand(ratio, direction = 1)

ggexpand(ratio, direction = 1, side = "hv")
}
\arguments{
\item{ratio}{expand x (y) axis limits by amount of xrange (yrange) * ratio}

\item{direction}{expand x axis limit at right hand side if direction is 1 (default), or left hand side if direction is -1}

\item{side}{one of 'h' for horizontal and 'v' for vertical or 'hv' for both (default).}
}
\value{
ggexpand object
}
\description{
hexpand

vexpand

expand xlim (ylim) by ratio of x (y) axis range
}
\examples{
x <- rtree(20)
x$tip.label <- paste0('RRRRREEEEEAAAAALLLLLYYYYY_Long_Lable_', x$tip.label)
p1 <- ggtree(x) + geom_tiplab()
p1 + ggexpand(1.5, side = "h")
}
\author{
Guangchuang Yu
}
