% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtreespace.R
\name{ggtreespace}
\alias{ggtreespace}
\title{Plot phylomorphospace}
\usage{
ggtreespace(tr, data, mapping = NULL, ...)
}
\arguments{
\item{tr}{a tree object. This should be an object of class that is
compatible with `ggtree`, typically an object of class
`phylo` or `treedata`.}

\item{data}{Trait data as a data frame or matrix, where each row
represents a tree tip or node.

    For data matching the number of tips, ancestral traits are reconstructed
    for internal nodes.

    For data equal to the total number of nodes, values are directly used as
    node coordinates.}

\item{mapping}{aesthetic mapping}

\item{...}{additional parameters for customization with `ggtree`. Please
use `?ggtree::ggtree` for more information.}
}
\value{
ggtreeSpace object
}
\description{
This function plots a phylomorphospace by mapping a tree
object onto a vector space like morphospace.
}
\examples{
library(ggtree)
library(phytools)
library(ggtreeSpace)

tr <- rtree(15)
td <- fastBM(tr, nsim = 2)
ggtreespace(tr, td) +
    geom_tippoint()

}
