% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_dodgex.r, R/position_dodgex2.r
\name{position_dodgex}
\alias{position_dodgex}
\alias{position_dodgex2}
\title{Dodge overlapping objects side-to-side which can be shifted verically or horizontally.}
\usage{
position_dodgex(
  width = NULL,
  hexpand = NA,
  vexpand = NA,
  preserve = c("total", "single")
)

position_dodgex2(
  width = NULL,
  preserve = c("total", "single"),
  hexpand = NA,
  vexpand = NA,
  padding = 0.1,
  reverse = FALSE
)
}
\arguments{
\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms.}

\item{hexpand}{numeric, Horizon expand for geoms that have a position, default is NA.}

\item{vexpand}{numeric, Vertical expand for geoms that have a position, default is NA.}

\item{preserve}{Should dodging preserve the total width of all elements
at a position, or the width of a single element?}

\item{padding}{Padding between elements at the same position. Elements are
shrunk by this proportion to allow space between them. Defaults to 0.1.}

\item{reverse}{If \code{TRUE}, will reverse the default stacking order.
This is useful if you're rotating both the plot and legend.}
}
\value{
position methods
}
\description{
Dodging preserves the vertical position of an geom while adjusting the
horizontal position. \code{position_dodgex2} is a special case of \code{position_dodgex}
for arranging box plots, which can have variable widths. \code{position_dodgex2}
also works with bars and rectangles. But unlike \code{position_dodgex},
\code{position_dodgex2} works without a grouping variable in a layer.
}
\examples{
library(ggplot2)
library(patchwork)
iris$ID <- rep(c(rep("test1", 15), rep("test2", 15), rep("test3", 20)),3)
p <- ggplot(iris, aes(x=Species,y=Petal.Length,fill=ID))
p1 <- p + geom_bar(stat="identity",position=position_dodgex())
p2 <- p + geom_bar(stat="identity",position=position_dodgex(vexpand=5))
p3 <- ggplot(iris, aes(x=Petal.Length, y=Species, fill=ID)) +
      geom_bar(stat="identity", orientation="y",
               position=position_dodgex(hexpand=5))
p4 <- p1 + p2 + p3
p4
p5 <- p + geom_boxplot(position=position_dodgex2())
p6 <- p + geom_boxplot(position=position_dodgex2(vexpand=5))
p7 <- ggplot(iris, aes(x=Petal.Length, y=Species, fill=ID)) +
      geom_boxplot(orientation="y",
                   position=position_dodgex2(hexpand=5))
p8 <- p5 + p6 + p7
p8
}
\seealso{
Other position adjustments: 
\code{\link{position_identityx}()},
\code{\link{position_points_sinax}()}
}
\concept{position adjustments}
