% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplot.R
\name{simplot}
\alias{simplot}
\title{simplot}
\usage{
simplot(
  file,
  query,
  window = 200,
  step = 20,
  group = FALSE,
  id,
  sep,
  sd = FALSE,
  smooth = FALSE,
  smooth_params = list(method = "loess", se = FALSE)
)
}
\arguments{
\item{file}{alignment fast file}

\item{query}{query sequence}

\item{window}{sliding window size (bp)}

\item{step}{step size to slide the window (bp)}

\item{group}{whether grouping sequence.(eg. For "A-seq1,A-seq-2,B-seq1 and 
B-seq2", using sep = "-" and id = 1 to divide sequences into groups A and 
B)}

\item{id}{position to extract id for grouping; only works if group = TRUE}

\item{sep}{separator to split sequence name; only works if group = TRUE}

\item{sd}{whether display standard deviation of 
similarity among each group; only works if group=TRUE}

\item{smooth}{FALSE(default)or TRUE; whether display smoothed spline.}

\item{smooth_params}{a list that add params for geom_smooth,
(default: smooth_params = list(method = "loess", se = FALSE))}
}
\value{
ggplot object
}
\description{
Sequence similarity plot
}
\examples{
fas <- system.file("extdata/GVariation/sample_alignment.fa", 
                    package="ggmsa")
simplot(fas, 'CF_YL21')
}
\author{
guangchuang yu
}
