% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_new_pos}
\alias{calc_new_pos}
\title{Calculate new x-position of each point}
\usage{
calc_new_pos(mpdata)
}
\arguments{
\item{mpdata}{an \code{MPdata} object.}
}
\value{
a \code{numeric} vector containing the scaled x-positions.
}
\description{
Calculate the actual x-positions of each point used for
the manhattan plot. \code{MPdata} object contains the unscaled positions
that has not been positioned according to the relative position and width
of each chromosome.
}
\details{
This is used calculate the actual positions used for the
inside \code{manhattan_plot} function. It was designed this way should the
scaling and relative positioning of each chromosome be changed (e.g. gap
between the )
}
\examples{

gwasdat <- data.frame(
  "chromosome" = rep(1:5, each = 30),
  "position" = c(replicate(5, sample(1:300, 30))),
  "pvalue" = rbeta(150, 1, 1)^5
)

mpdata <- manhattan_data_preprocess(
  gwasdat, pval.colname = "pvalue", chr.colname = "chromosome", pos.colname = "position",
  chr.order = as.character(1:5)
)

calc_new_pos(mpdata)

}
