% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway_functions.R
\name{process_reaction}
\alias{process_reaction}
\title{process_reaction}
\usage{
process_reaction(g, single_edge = FALSE, keep_no_reaction = TRUE)
}
\arguments{
\item{g}{graph}

\item{single_edge}{discard one edge when edge type is `reversible`}

\item{keep_no_reaction}{keep edges not related to reaction}
}
\value{
tbl_graph
}
\description{
process the kgml of global maps
e.g. in ko01100
}
\details{
Typically, `process_line` function is used to draw relationships 
as in the original KGML positions, however, the `coords` properties
is not considering the direction of reactions (substrate -> product),
thus if it is preferred, `process_reaction` is used to populate
new edges corresponding to `substrate -> product` and `product -> substrate`
if the reaction is reversible.
}
\examples{
gm_test <- create_test_pathway(line=TRUE)
test <- process_reaction(gm_test)

}
