% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggkegg.R
\name{ggkegg}
\alias{ggkegg}
\title{ggkegg}
\usage{
ggkegg(
  pid,
  layout = "native",
  return_igraph = FALSE,
  return_tbl_graph = FALSE,
  pathway_number = 1,
  convert_org = NULL,
  convert_first = TRUE,
  convert_collapse = NULL,
  convert_reaction = FALSE,
  delete_undefined = FALSE,
  delete_zero_degree = FALSE,
  numeric_attribute = NULL,
  node_rect_nudge = 0,
  group_rect_nudge = 2,
  module_type = "definition",
  module_definition_type = "text"
)
}
\arguments{
\item{pid}{KEGG Pathway id e.g. hsa04110}

\item{layout}{default to "native", using KGML positions}

\item{return_igraph}{return the resulting igraph object}

\item{return_tbl_graph}{return the resulting tbl_graph object
(override `return_igraph` argument)}

\item{pathway_number}{pathway number if passing enrichResult}

\item{convert_org}{these organism names are fetched from REST API
and cached, and used to convert the KEGG identifiers.
e.g. c("hsa", "compound")}

\item{convert_first}{after converting, take the first element as 
node name when multiple genes are listed in the node}

\item{convert_collapse}{if not NULL, collapse 
the gene names by this character
when multiple genes are listed in the node.}

\item{convert_reaction}{reaction name (graph attribute `reaction`) 
will be converted to reaction formula}

\item{delete_undefined}{delete `undefined` node specifying group,
should be set to `TRUE` when the layout is not from native KGML.}

\item{delete_zero_degree}{delete nodes with zero degree,
default to FALSE}

\item{numeric_attribute}{named vector for appending numeric attribute}

\item{node_rect_nudge}{parameter for nudging the node rect}

\item{group_rect_nudge}{parameter for nudging the group node rect}

\item{module_type}{specify which module attributes to obtain
(definition or reaction)}

\item{module_definition_type}{`text` or `network` 
when parsing module definition.
If `text`, return ggplot object. If `network`, return `tbl_graph`.}
}
\value{
ggplot2 object
}
\description{
main function parsing KEGG pathway data,
making igraph object and passing it to ggraph.
}
\examples{
## Use pathway ID to obtain `ggraph` object directly.
g <- ggkegg("hsa04110")
g + geom_node_rect()
}
