% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcyto_flowSet.R
\name{ggcyto_add}
\alias{ggcyto_add}
\alias{+.ggcyto_flowSet}
\alias{+}
\alias{+,ggcyto_flowSet-method}
\alias{+.ggcyto_GatingSet}
\alias{+,ggcyto_GatingSet-method}
\alias{+.ggcyto_GatingLayout}
\alias{+,ggcyto_GatingLayout-method}
\alias{+.ggcyto_ncdfFlowList}
\alias{+,ggcyto_GatingLayout,ANY-method}
\alias{+,ggcyto_GatingSet,ANY-method}
\alias{+,ggcyto_flowSet,ANY-method}
\title{overloaded '+' method for ggcyto}
\usage{
e1 + e2
}
\arguments{
\item{e1}{An object of class \code{ggcyto} or a class inheriting from \code{ggcyto}, such
as \code{ggcyto_flowSet}, \code{ggcyto_GatingSet}, or \code{ggcyto_GatingLayout}. In the case
of \code{ggcyto_GatingLayout}, the component of \code{e2} will be added to each subsidiary plot.}

\item{e2}{A component to add to \code{e1}}
}
\value{
ggcyto object
}
\description{
It tries to copy pData from ggcyto object to the gate layers
so that the gate layer does not need to have \code{pd} to be supplied explicitly by users.
It also calculates population statistics when geom_stats layer is added.
It supports addition ggcyto layers such as 'ggcyto_par' and 'labs_cyto'.
}
\examples{

## flowSet
data(GvHD)
fs <- GvHD[subset(pData(GvHD), Patient \%in\%5:7 & Visit \%in\% c(5:6))[["name"]]]
p <- ggcyto(fs, aes(x = `FSC-H`, y =  `SSC-H`)) + geom_hex(bins = 128)
#add rectangleGate layer (2d)
rect.g <- rectangleGate(list("FSC-H" =  c(300,500), "SSC-H" = c(50,200)))
rect.gates <- sapply(sampleNames(fs), function(sn)rect.g)
p + geom_gate(rect.gates) + geom_stats()

## GatingSet
dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
p <- ggcyto(gs, aes(x = CD4, y = CD8), subset = "CD3+") + geom_hex(bins = 64)
p <- p + geom_gate("CD4") + geom_stats() #plot CD4 gate and it is stats
p
p + axis_x_inverse_trans() #inverse transform the x axis into raw scale

## GatingLayout
#autplot for GatingSet
dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
gh <- gs[[1]]
p <- autoplot(gh)
class(p)
# customize the font size of strip text for each ggcyo plots contained in GatingLayout object
p + theme(strip.text = element_text(size = 14))
}
