% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.R
\name{fortify.filterList}
\alias{fortify.filterList}
\title{Convert a filterList to a data.table useful for ggplot}
\usage{
\method{fortify}{filterList}(model, data = NULL, nPoints = NULL, ...)
}
\arguments{
\item{model}{filterList}

\item{data}{not used}

\item{nPoints}{not used}

\item{...}{not used.}
}
\value{
data.table
}
\description{
It tries to merge with pData that is associated with filterList as attribute 'pd'
}
\examples{
dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
gates <- gs_pop_get_gate(gs, "CD4")
gates <- as(gates, "filterList") #must convert list to filterList in order for the method to dispatch properly
fortify(gates)
}
