% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_gate.R
\name{geom_gate}
\alias{geom_gate}
\alias{geom_gate.default}
\alias{geom_gate.list}
\alias{geom_gate.filter}
\alias{geom_gate.filterList}
\alias{geom_gate.quadGate}
\alias{geom_gate.character}
\alias{geom_gate.filters}
\alias{geom_gate.filtersList}
\alias{geom_gate.logical}
\alias{geom_gate.logicalFilterResult}
\title{Add a gate layer to a ggcyto plot.}
\usage{
geom_gate(data, ...)

\method{geom_gate}{filterList}(data, pd, nPoints = 100, ...)

\method{geom_gate}{filter}(data, mapping = NULL, fill = NA, colour = "red", nPoints = 100, ...)
}
\arguments{
\item{data}{a filter (Currently only rectangleGate (1d or 2d), polygonGate, ellipsoidGate are supported.)
or a list of these gates
or filterList
or character specifying a gated cell population in the GatingSet}

\item{...}{other arguments}

\item{pd}{pData (data.frame) that has rownames represents the sample names used as key to be merged with filterList}

\item{nPoints}{used for interpolating polygonGates to prevent them from losing shape when truncated by axis limits}

\item{mapping}{The aesthetic mapping}

\item{fill}{fill color for the gate. Not filled by default.}

\item{colour}{default is red}
}
\value{
a geom_gate layer
}
\description{
When 'data' is a gate (or flowCore filter) or a list of gates or a filterList object.
When it is used directly with 'ggplot', pdata of the flow data must be supplied through 'pd' argument explicitly in order for
the gates to be dispatched to each panel.
However It is not necessary when used with 'ggcyto' wrapper since the latter will attach pData automatically.
}
\details{
When 'data' is a character, it construct an abstract geom layer for a character that represents nodes in a Gating tree
and will be instanatiated later as a specific geom_gate layer or layers based on the gates extracted from the given GatingSet object.
}
\examples{
data(GvHD)
fs <- GvHD[subset(pData(GvHD), Patient \%in\%5:7 & Visit \%in\% c(5:6))[["name"]]]
p <- ggcyto(fs, aes(x = `FSC-H`, y =  `SSC-H`))
p <- p + geom_hex(bins = 128)
rect.g <- rectangleGate(list("FSC-H" =  c(300,500), "SSC-H" = c(50,200)))
#constuctor for a list of filters
rect.gates <- sapply(sampleNames(fs), function(sn)rect.g)
p + geom_gate(rect.gates)

dataDir <- system.file("extdata",package="flowWorkspaceData")
gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE))
p <- ggcyto(gs, aes(x = CD4, y = CD8), subset = "CD3+") + geom_hex(bins = 64)
# add gate layer by gate name
p + geom_gate("CD4")
}
