% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.R
\name{fortify.ellipsoidGate}
\alias{fortify.ellipsoidGate}
\title{Convert a ellipsoidGate to a data.table useful for ggplot}
\usage{
\method{fortify}{ellipsoidGate}(model, data = NULL, ...)
}
\arguments{
\item{model}{ellipsoidGate}

\item{data}{data range used for polygon interpolation.}

\item{...}{not used.}
}
\value{
data.table
}
\description{
It interpolates the ellipsoidGate to polygongate before fortifying it.
}
\examples{
## Defining the gate
cov <- matrix(c(6879, 3612, 3612, 5215), ncol=2,
              dimnames=list(c("FSC-H", "SSC-H"), c("FSC-H", "SSC-H")))
mean <- c("FSC-H"=430, "SSC-H"=175)
eg <- ellipsoidGate(filterId= "myEllipsoidGate", .gate=cov, mean=mean)
fortify(eg)
}
