% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{extractors}
\alias{extractors}
\alias{getCor}
\alias{getShared}
\alias{getTotals}
\title{Helper Functions for \code{gg4way}}
\usage{
getCor(p1)

getShared(p1)

getTotals(p1)
}
\arguments{
\item{p1}{The plot from \link{gg4way}}
}
\value{
Each function returns a different result:
\tabular{ll}{
\code{getCor} \tab A numeric \cr
\tab \cr
\code{getShared} \tab A \link[tibble:tbl_df-class]{tibble} \cr
\tab \cr
\code{getTotals} \tab A \link[janitor]{tabyl} \cr
}
}
\description{
These helper functions provide data used in the plot:
\tabular{ll}{
\code{getCor} \tab Get the correlation of the logFC of all genes \cr
\tab \cr
\code{getShared} \tab Get only the shared genes that pass the thresholds \cr
\tab \cr
\code{getTotals} \tab Get the totals of overlap categories \cr
}
}
\examples{
data("airwayFit")
p1 <- airwayFit |>
    gg4way(x = "N61311 vs N052611",
           y = "N061011 vs N052611")

## Correlation
getCor(p1)

## Shared
getShared(p1)

## Totals
getTotals(p1)

}
