% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalize.R
\name{geva.quick}
\alias{geva.quick}
\title{All-In-One Function for GEVA Intermediate Procedures}
\usage{
geva.quick(gobject, ...)
}
\arguments{
\item{gobject}{A \code{GEVAInput}, or any object that returns a \code{GEVAInput} upon calling \code{inputdata(gobject)} (\emph{e.g.}, \code{\linkS4class{GEVASummary}} or \code{\linkS4class{GEVAResults}}).}

\item{...}{Optional arguments passed to \code{\link[=geva.summarize]{geva.summarize()}}, \code{\link[=geva.quantiles]{geva.quantiles()}}, \code{\link[=geva.cluster]{geva.cluster()}}, and \code{\link[=geva.finalize]{geva.finalize()}}}
}
\value{
A \code{\linkS4class{GEVAResults}} object
}
\description{
Given a \code{\linkS4class{GEVAInput}} object, applies the \code{\link[=geva.summarize]{geva.summarize()}}, \code{\link{geva.quantiles}}, \code{\link{geva.cluster}}, and \code{\link{geva.finalize}} in a single call. Optional arguments are passed to the internal calls of these functions.
}
\details{
This function performs the summarization, quantile detecetion, and clustering of an input data, then merges the results together and, if applicable, performs a factor analysis. If the \code{gobject} is not a \code{GEVAInput}, it must provide a valid \code{GEVAInput} object when called by \code{inputdata(gobject)}. Moreover, all parameters used in previous analysis will be taken into account. For instance, if \code{gobject} is a \code{GEVASummary} obtained by using \code{variation.method='mad'}, the internal call to \code{geva.summarize} in this function will use \code{variation.method='mad'} as well, unless if another parameter for \code{variation.method} is specified in the \code{...} arguments.

Therefore, this function can be useful not only as a shortcut to analyze \code{GEVAInput} but also for parameter testing when applied to a \code{GEVAResults} object, since the previous parameters are reused, while the specified parameters are overriden.
}
\examples{
## Basic usage using a random generated input
ginput <- geva.ideal.example()   # Generates a random input example
gresults <- geva.quick(ginput)   # Performs the entire analysis (default parameters)

print(head(top.genes(gresults))) # Prints the results
plot(gresults)                        # Plots the final SV-plot


## Example with non-default parameters
ginput <- geva.ideal.example()   # Generates a random input example
gresults <- geva.quick(ginput,
                       summary.method="median",
                       variation.method="mad",
                       quantiles.method="density",
                       cluster.method="density",
                       resolution=0.32)

print(head(top.genes(gresults))) # Prints the results
plot(gresults)                   # Plots the final SV-plot

}
