% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idealtesting.R
\name{geva.ideal.example}
\alias{geva.ideal.example}
\title{GEVA ``Ideal'' Example for Package Testing}
\usage{
geva.ideal.example(probecount = 10000, nfactors = 3, colsperfactor = 3)
}
\arguments{
\item{probecount}{\code{integer}, number of probes (\emph{i.e.}, table rows)}

\item{nfactors}{\code{integer}, number of factors (\emph{e.g.}, experimental groups)}

\item{colsperfactor}{\code{integer}, number of columns (\emph{e.g.}, experiments) per factor}
}
\value{
A \code{\linkS4class{GEVAInput}} object. The included tables are composed by \code{probecount} rows and \code{nfactors} * \code{colsperfactor} columns
}
\description{
Generates a random example of GEVAInput object that simulates an ideal analysis dataset. Used for testing purposes only.
}
\examples{
## "Ideal" input example
ginput <- geva.ideal.example()     # Generates a random example
gsummary <- geva.summarize(ginput) # Summarizes the generated data
plot(gsummary)                     # Plots the summarized data

}
\seealso{
\code{\link{geva.summarize}}
}
