% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalize.R, R/factoring.R
\docType{data}
\name{geva.finalize}
\alias{geva.finalize}
\alias{options.factoring.p.adjust}
\title{Concatenating GEVA calculations into the final results}

\usage{
geva.finalize(
  gsummary,
  ...,
  p.value = 0.05,
  p.val.adjust = options.factoring.p.adjust,
  constraint.factors = TRUE
)

options.factoring.p.adjust
# c("partial.quantiles", "holm", "hochberg", "hommel", 
#   "bonferroni", "BH", "BY", "fdr", "none")
}
\arguments{
\item{gsummary}{a \code{\linkS4class{GEVASummary}} object}

\item{...}{Intermediate results produced from the \code{gsummary} object, such as clusters (\code{\linkS4class{GEVACluster}}), quantiles (\code{\linkS4class{GEVAQuantiles}}), or any other object inherited from \code{\linkS4class{GEVAGroupSet}}}

\item{p.value}{\code{numeric} (0 to 1), p-value cutoff used in the ANOVA procedures (factor analysis only)}

\item{p.val.adjust}{\code{character}, p-value correction method (factor analysis only). Possible values are: "partial.quantiles", "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{constraint.factors}{\code{logical}. If \code{TRUE}, the S values are restricted to the range within the quantile centroids (factor analysis only)}
}
\value{
A \code{\linkS4class{GEVAResults}} object, containing the entire set of results. The relevant genes can be retrieved using \code{\link[=top.genes]{top.genes()}}
}
\description{
Merges the obtained information (Summarization, Clustering, and Quantiles), then applies the final steps to produce the classification results for the SV points (genes).
}
\details{
In this procedure, the SV points (\emph{i.e.}, each row in the \code{GEVASummary} object) are classified according to the detected quantiles (see \link{geva.quantiles}), whose results can be adjusted using other grouping analysis results such as clusters (see \link{geva.cluster}). To achieve the best statistical accuracy, both \code{GEVAQuantiles} and \code{GEVACluster} objects must be given in the \code{...} as optional arguments. If a \code{GEVAQuantiles} argument is not present, it is automatically calculated using the default parameters.

If multiple factors are present in the \code{GEVASummary} object (retrieved by \code{factors(gsummary)}), a factor analysis is also performed, giving two additional possible classifications (\emph{factor-dependent} and \emph{factor-specific}) besides the default ones (\emph{similar}, \emph{basal}, and \emph{sparse}).

In factor analysis, an ANOVA is applied for each gene using Fisher's and Levene's tests to distinguish genes whose \emph{logFC} (differential expression) variation is dependent or specific to the analyzed factors based on the p-value cutoff. The \code{p.val.adjust} argument defines how these p-values will be adjusted: by quantile separation between each factor (\code{"partial.quantiles"} method); or by one of the default methods listed in \link[stats:p.adjust]{stats::p.adjust.methods}.

The \code{constraint.factors} argument determines if the \code{S} values (summarized \emph{logFC}) will be limited to the range between the quantile centroids during factor analysis. For example, if the quantile centroids were -0.90, 0.00, and 0.90 in the S axis, values such as -1.53 and 2.96 would be converted to -0.90 and 0.90, respectively. This constraint is particularly applied to avoid significative observations from ANOVA based on multiple degrees of differential expression.
\cr
In another example to illustrate the constraint of factors, given two sets of values: A = (-1.00, -1,10, 0.00, 0.20, 1.00, 1.15), and B = (0.00, 0.12, 1.11, 1.00, 1.95, 2.00), with the centroids located in C = (-0.90, 0.00, 0.90), and the factors F = (Cond1, Cond1, Cond2, Cond2, Cond3, Cond3). If \code{constraint.factors} is \code{FALSE}, both A and B are considered as significantly separated factors, whereas if \code{TRUE}, only A will present a significant separation, since in B the values 1.11, 1.00, 1.95, and 2.00 are converted to 0.90. In qualitative terms, if \code{constraint.factors} is \code{TRUE}, all values above 0.90 are considered the same over-expressed values, ensuring that they will fit in the same degree of differential expression. Hence, in this example using the constrained values, B would not represent a significant separation between the factors Cond1, Cond2, and Cond3.
}
\note{
To perform factor analysis, the following observations must be considered:
\itemize{
\item The factors must be defined in the provided data. They can be retrieved using the \code{\link{factors}} accessor. If factors are not present or are entirelly composed by \code{NA}, they can be assigned through \code{\link{factors<-}} by providing a \code{factor} or \code{character} vector of the same length of the input columns;
\item Each factor must include two or more values, since the factor analysis is based on ANOVA and at least two values are needed to variance calculation;
\item Columns whose factor value is \code{NA} are not considered.
}
}
\examples{
## Finalizing example using a random generated input
ginput <- geva.ideal.example()       # Generates a random input (for testing purposes only)
gsummary <- geva.summarize(ginput)   # Summarizes the input
gquant <- geva.quantiles(gsummary)   # Calculates the quantiles
gclust <- geva.cluster(gsummary)     # Calculates the clusters
gresults <- geva.finalize(gsummary, gquant, gclust)  # Finishes the results

head(top.genes(gresults))            # Prints the final results
plot(gresults)                       # Plots the final SV-plot

}
\seealso{
\link[stats]{p.adjust.methods}
}
\keyword{datasets}
