% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_GEVAGroupedSummary.R
\docType{class}
\name{GEVAGroupedSummary-class}
\alias{GEVAGroupedSummary-class}
\alias{show,GEVAGroupedSummary-method}
\alias{plot,GEVAGroupedSummary,missing-method}
\alias{groupsets,GEVAGroupedSummary-method}
\alias{groupsets<-,GEVAGroupedSummary,GEVAGroupSet-method}
\alias{quantiles,GEVAGroupedSummary-method}
\alias{cluster.method,GEVAGroupedSummary-method}
\alias{analysis.params,GEVAGroupedSummary-method}
\alias{as.matrix.GEVAGroupedSummary}
\alias{as.expression.GEVAGroupedSummary}
\alias{lines.GEVAGroupedSummary}
\alias{points.GEVAGroupedSummary}
\title{GEVA Grouped Summary-Variation Table}

\value{
A \code{\linkS4class{GEVAGroupedSummary}} object
}
\description{
The \code{GEVAGroupedSummary} class inherits the \code{\linkS4class{GEVASummary}} class and includes group analysis data (\emph{e.g.}, clustering and quantile detection).
}
\section{Slots}{

\describe{
\item{\code{sv}}{\code{numeric matrix} composed by two columns: \code{S} (summary) and \code{V} (variation)
\cr (Inherited from \code{\linkS4class{SVTable}})}

\item{\code{inputdata}}{GEVAInput-class with the data input
\cr (Inherited from \code{\linkS4class{GEVASummary}})}

\item{\code{sv.method}}{Names of the statistical methods used to summarize data
\cr (Inherited from \code{\linkS4class{GEVASummary}})}

\item{\code{info}}{list with additional information
\cr (Inherited from \code{\linkS4class{GEVASummary}})}

\item{\code{groupsetlist}}{\code{\linkS4class{TypedList}} of \code{\linkS4class{GEVAGroupSet}} objects}
}}

\section{Methods}{
(See also the inherited methods from \code{\linkS4class{GEVASummary}})\cr 

\sspace\cr\strong{Conversion and coercion}
\describe{
\item{\code{as.expression(x, ginput, ...)}}{Converts this object to \code{expression}}
\item{\code{as.matrix(x, ...)}}{Converts this object to \code{matrix}}
}
\sspace\cr\strong{Plotting}
\describe{
\item{\code{lines(x, ...)}}{Draws delimiters within quantiles and convex hulls around the clustered points}
\item{\code{plot(x, y, ...)}}{Draws a SV-plot. The horizontal axis is for \emph{summary} (S) and the vertical axis is for \emph{variation} (V).
\cr In addition, highlights the included group sets}
\item{\code{points(x, ...)}}{Generic \code{points} implementation for \code{GEVAGroupedSummary}}
}
\sspace\cr\strong{Properties}
\describe{
\item{\code{analysis.params(gobject)}}{Returns a \code{list} of analysis parameters passed to \code{\link{geva.cluster}} to obtain this object}
}
\sspace\cr\strong{Sub-slot accessors}
\describe{
\item{\code{cluster.method(object)}}{Gets a \code{character} vector listing the \code{cluster.method} from each group set}
\item{\code{quantiles(object)}}{Gets the \code{\linkS4class{GEVAQuantiles}}, or \code{NULL} if not present}
}
}

