% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMatrix.R
\docType{methods}
\name{plotMeta}
\alias{plotMeta}
\title{Line plot(s) for meta-region profiles}
\usage{
plotMeta(mat, centralTend = "mean", overlay = TRUE, winsorize = c(0, 100),
  profile.names = NULL, xcoords = NULL, meta.rescale = FALSE,
  smoothfun = NULL, line.col = NULL, dispersion = NULL,
  dispersion.col = NULL, ylim = NULL, ylab = "average score",
  xlab = "bases", ...)
}
\arguments{
\item{mat}{\code{ScoreMatrix} or \code{ScoreMatrixList} object. If it is a 
\code{ScoreMatrixList} object, all matrices in the ScoreMatrixList should have 
the same number of 
columns.}

\item{centralTend}{a character that determines central tendency of meta-profile(s). 
It takes "mean" (default) or "median".}

\item{overlay}{If TRUE multiple profiles will be overlayed in the same plot
(Default:TRUE). If FALSE, and mat is a ScoreMatrixList, consider
using par(mfrow=c(1,length(mat))) to see the plots from all
matrices at once.}

\item{winsorize}{Numeric vector of two, defaults to c(0,100). This vector 
determines the upper and lower percentile values to limit the 
extreme values. For example, c(0,99) will limit the values to
only 99th percentile, everything above the 99 percentile will 
be equalized to the value of 99th percentile.This is useful 
for visualization of matrices that have outliers.}

\item{profile.names}{a character vector for names of the profiles. The order
should be same as the as the order of ScoreMatrixList.}

\item{xcoords}{a numeric vector which designates 
relative base positions of the meta-region profiles.
For example, for a 2001 column ScoreMatrix, xcoord=-1000:1000 indicates
relative positions of each column in the score matrix. If NULL (Default),
xcoords equals to 1:ncol(mat)}

\item{meta.rescale}{if TRUE meta-region profiles are scaled to 0 to 1 range by
subtracting the min from profiles and dividing them by max-min.
If dispersion is not NULL, then dispersion will be scaled as well.}

\item{smoothfun}{a function to smooth central tendency and dispersion bands (Default: NULL), e.g. 
stats::lowess.}

\item{line.col}{color of lines for \code{centralTend} of meta-region profiles. Defaults to colors from
\code{rainbow()} function.}

\item{dispersion}{shows dispersion interval bands around \code{centralTend} (default:NULL). It takes 
       one of the character:
\itemize{
 \item{"se"}{shows standard error of the mean and 95 percent confidence interval for the mean}
 \item{"sd"}{shows standard deviation and 2*(standard deviation)}
 \item{"IQR"}{shows 1st and 3rd quartile and 
              confidence interval around the median based on the median +/- 1.57 * IQR/sqrt(n) (notches)}
}}

\item{dispersion.col}{color of bands of \code{dispersion}.
Defaults to colors from \code{rainbow()} and transparency is set to 0.5
(rainbow(length(mat), alpha = 0.5)).}

\item{ylim}{same as \code{ylim} at \code{\link{plot}} function. 
if NULL ylim is estimated from all meta-region profiles.}

\item{ylab}{same as \code{ylab} at \code{\link{plot}} function. 
Default: "average score"}

\item{xlab}{same as \code{xlab} at \code{\link{plot}} function. 
Default: "bases"}

\item{...}{other options to \code{\link{plot}}}
}
\value{
returns the meta-region profiles invisibly as a matrix.
}
\description{
Function calculates meta-profile(s) from a ScoreMatrix or a ScoreMatrixList, then
produces a line plot or a set of line plots for meta-region profiles
}
\note{
Score matrices are plotted according to ScoreMatrixList order. 
If ScoreMatrixList contains more than one matrix then they will
overlap each other on a plot, i.e.
the first one is plotted first and every next one overlays previous one(s) and 
the last one is the topmost.

Missing values in data slow down plotting dispersion around central tendency.
The reason is that dispersion is plotted only for non-missing values,
for each segment that
contains numerical values \code{graphics::polygon} function is used to plot dispersion bands.
There might be a situation, when in a column of ScoreMatrix is only one
numeric number and the rest are NAs, then at corresponding position 
only central tendency will be plotted.

Notches show the 95 percent confidence interval for the median 
according to an approximation based on the normal distribution.
They are used to compare groups - if notches corresponding to adjacent base pairs
on the plot do not overlap, this is strong evidence that medians differ.
Small sample sizes (5-10) can cause notches to extend beyond the interquartile range (IQR) 
(Martin Krzywinski \emph{et al}. \emph{Nature Methods 11}, 119-120 (2014))
}
\examples{
 data(cage)
 data(promoters)
 scores1=ScoreMatrix(target=cage,windows=promoters,strand.aware=TRUE)

 data(cpgi)
 scores2=ScoreMatrix(target=cpgi,windows=promoters,strand.aware=TRUE)

 # create a new ScoreMatrixList
 x=new("ScoreMatrixList",list(scores1,scores2))
 \donttest{
 plotMeta(mat=x,overlay=TRUE,main="my plotowski")

 # plot dispersion nd smooth central tendency and variation interval bands
 plotMeta(mat=x, centralTend="mean", dispersion="se", winsorize=c(0,99), 
         main="Dispersion as interquartile band", lwd=4, 
         smoothfun=function(x) stats::lowess(x, f = 1/5))
 }
}
