% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cordiff.dep.R
\name{cordiff.dep}
\alias{cordiff.dep}
\title{Function to estimate whether two dependent correlations differ}
\usage{
cordiff.dep(r.x1y, r.x2y, r.x1x2, n,
  alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{r.x1y}{The correlation between x1 and y where y is typically your outcome variable.}

\item{r.x2y}{The correlation between x2 and y where y is typically your outcome variable.}

\item{r.x1x2}{The correlation between x1 and x2 (the correlation between your two predictors).}

\item{n}{The sample size.}

\item{alternative}{A character string specifying the alternative hypothesis, must be
one of "two.sided" default), "greater" or "less". You can specify just the initial letter.}
}
\value{
Vector of three values: t statistics, degree of freedom, and p-value.
}
\description{
This function tests for statistical differences between two dependent correlations
using the formula provided on page 56 of Cohen & Cohen (1983). The function returns
a t-value, the DF and the p-value.
}
\details{
This function is inspired from the cordif.dep.
}
\examples{
# load VDX dataset
data(vdxs)
# retrieve ESR1, AURKA and MKI67 gene expressions
x1 <- data.vdxs[ ,"208079_s_at"]
x2 <- data.vdxs[ ,"205225_at"]
y <- data.vdxs[ ,"212022_s_at"]
# is MKI67 significantly more correlated to AURKA than ESR1?
cc.ix <- complete.cases(x1, x2, y)
cordiff.dep(r.x1y=abs(cor(x=x1[cc.ix], y=y[cc.ix], use="everything",
  method="pearson")), r.x2y=abs(cor(x=x2[cc.ix], y=y[cc.ix],
  use="everything", method="pearson")), r.x1x2=abs(cor(x=x1[cc.ix],
  y=x2[cc.ix], use="everything", method="pearson")), n=sum(cc.ix),
  alternative="greater")

}
\references{
Cohen, J. & Cohen, P. (1983) "Applied multiple regression/correlation analysis for the
behavioral sciences (2nd Ed.)" Hillsdale, nJ: Lawrence Erlbaum Associates.
}
\seealso{
\link[stats:cor]{stats::cor}, \link[stats:t.test]{stats::t.test}, \link{compareProtoCor}
}
