% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeWordCloud.r
\name{makeWordCloud}
\alias{makeWordCloud}
\title{Makes word cloud from gene ontology terms}
\usage{
makeWordCloud(organism, start, end, GOcategory, GOspecies)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}

\item{GOcategory}{Either BP, CC, or MF.}

\item{GOspecies}{Either org.Ag.eg.db (mosquito), org.Bt.eg.db (bovine), org.Ce.eg.db (worm), org.Cf.eg.db (canine), org.Dm.eg.db (fly), org.Dr.eg.db (zebrafish), org.Gg.eg.db (chicken), org.Hs.eg.db (human), org.Mm.eg.db (mouse), org.Mmu.eg.db (rhesus), org.Pt.eg.db (chimpanzee), org.Rn.eg.db (rat), org.Sc.sgd.db (yeast), org.Ss.eg.db (pig), or org.Xl.eg.db (frog).}
}
\value{
A word cloud comprised of words gathered from gene ontology terms of either a BP, CC, or MF category.
}
\description{
Creates word cloud from gene ontology terms derived from either biological process (BP), cellular compartment (CC), or molecular function (MF) of genes-under-peaks that are unique between two different upstream extension levels.
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksInput(fpath)
library(tm)
library(SnowballC)
library(wordcloud)
library(RColorBrewer)
library(org.Rn.eg.db)
makeWordCloud(rat, 0, 500, BP, org.Rn.eg.db)

}
