% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getWeights}
\alias{getWeights}
\alias{getWeights,ClassifierParameters-method}
\title{Obtain classifier weights.}
\usage{
getWeights(object)

\S4method{getWeights}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
A numeric vector.
}
\description{
\code{getWeights} returns the probe weights associated with
the classifier.
}
\examples{
aClassifier <- getClassifier("EMC92")
getWeights(aClassifier)
}
\seealso{
Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}
}
\concept{classifier information functions}
