% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_genes}
\alias{get_genes}
\title{Retrieve all genes}
\usage{
get_genes(
  genes,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{genes}{A vector of NCBI IDs, Ensembl IDs or gene symbols.}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the querried gene(s)
A list if \code{raw = TRUE}.

The fields of the output data.table are:

\itemize{
\item \code{gene.symbol}: Symbol for the gene
\item \code{gene.ensembl}: Ensembl ID for the gene
\item \code{gene.NCBI}: NCBI id for the gene
\item \code{gene.name}: Name of the gene
\item \code{gene.aliases}: Gene aliases. Each row includes a vector
\item \code{gene.MFX.rank}: Multifunctionality rank for the gene
\item \code{taxon.name}: Name of the species
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underlying database used in Gemma for the taxon
}
}
\description{
Retrieve all genes
}
\examples{
get_genes("DYRK1A")
get_genes(c("DYRK1A", "PTEN"))
}
\keyword{gene}
