% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_prepare_input.R
\name{gemini_prepare_input}
\alias{gemini_prepare_input}
\title{Prepare input before Model creation}
\usage{
gemini_prepare_input(Input, gene.columns, sample.col.name = "samplename")
}
\arguments{
\item{Input}{An object of class gemini.input}

\item{gene.columns}{a character vector of length(2)}

\item{sample.col.name}{a character indicating the name of the sample column (default = "samplename")}
}
\value{
a (prepared) gemini.input object
}
\description{
This is an internal function to GEMINI, allowing for data cleanup and preprocessing before a Model object is created. This removes any gene pairs targeting the same gene twice, and removes any empty samples/replicates.
}
\examples{
data("Input", package = "gemini")
Input \%<>\% gemini_prepare_input(gene.columns = c("U6.gene", "H1.gene"))

}
