% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_calculate_lfc.R
\name{gemini_calculate_lfc}
\alias{gemini_calculate_lfc}
\title{Calculate log-fold change}
\usage{
gemini_calculate_lfc(Input, counts = "counts", sample.column.name = "samplename",
normalize = TRUE, CONSTANT = 32)
}
\arguments{
\item{Input}{a gemini.input object containing an object named \code{counts}.}

\item{counts}{a character indicating the name of a matrix of counts within \code{Input} that can be used to calculate log-fold changes (defaults to "counts").}

\item{sample.column.name}{a character or integer indicating which column of \code{Input$replicate.map} describes the samples.}

\item{normalize}{a logical indicating if counts should be median-normalized, see Details (default = TRUE)}

\item{CONSTANT}{a numeric indicating a constant value that shifts counts to reduce outliers, see Details (default = 32).}
}
\value{
a gemini object identical to \code{Input} that also contains new objects called \code{LFC} and \code{sample.annot}.
}
\description{
Given a gemini.input object, calculates log-fold change from \code{counts}.
}
\details{
See Methods from Zamanighomi et al. 2019 for a comprehensive
description of the calculation of log-fold change, normalization,
and count processing.

If multiple early time-points are provided for a given sample, they are treated as replicates and averaged,
and used to compute log-fold change against any specified late time points.

If a sample has a specific early-time point, these are matched as long as the sample names are identical between
the early and late timepoints in \code{sample.column.name}
}
\examples{

data("Input", package = "gemini")
Input <- gemini_calculate_lfc(Input)

head(Input$LFC)

}
