% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkPackage}
\alias{checkPackage}
\title{Check R package}
\usage{
checkPackage(
  pkgName,
  repoDir,
  subdir = NULL,
  fail_on = "warning",
  bioc_check = FALSE,
  run_examples = TRUE,
  skip_lint = FALSE,
  skip_tests = FALSE,
  skip_pkgdown = FALSE,
  build_vignettes = TRUE,
  check_vignettes = TRUE,
  as_cran = FALSE
)
}
\arguments{
\item{pkgName}{String of package name.}

\item{repoDir}{String of path to repository directory.}

\item{subdir}{String of relative path to the R package root directory
from the \code{repoDir}.}

\item{fail_on}{String specifying the level at which check fail. Supported
values: \code{"note"}, \code{"warning"} (default) and \code{"error"}.}

\item{bioc_check}{Logical whether bioc check should be performed}

\item{run_examples}{Logical whether examples check should be performed}

\item{skip_lint}{skip lint checks}

\item{skip_tests}{skip tests}

\item{skip_pkgdown}{skip pkgdown build}

\item{build_vignettes}{build vignettes}

\item{check_vignettes}{check vignettes}

\item{as_cran}{run with as_cran flag}
}
\value{
\code{NULL} invisibly.
}
\description{
Used in gDR platform pacakges' CI/CD pipelines to check that the package
abides by gDRstyle stylistic requirements, passes \code{rcmdcheck}, and
ensures that the \code{dependencies.yml} file used to build
gDR platform's docker image is kept up-to-date with the dependencies
listed in the package's \code{DESCRIPTION} file.
}
\examples{
checkPackage(
  pkgName = "fakePkg",
  repoDir = system.file(package = "gDRstyle", "tst_pkgs", "dummy_pkg"),
  fail_on = "error"
)

}
\keyword{check}
