% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pset_to_gdrDF.R
\name{convert_pset_to_df}
\alias{convert_pset_to_df}
\title{Convert a PharmacoSet to a data.table that is prepare for input into gDR pipeline}
\usage{
convert_pset_to_df(pharmacoset, run_parallel = TRUE, workers = 2L)
}
\arguments{
\item{pharmacoset}{PharmacoSet object}

\item{run_parallel}{logical, TRUE (default) if to run functions in Parallel, FALSE to run in serial}

\item{workers}{integer, number of workers defaults to 2L if run_parallel is TRUE}
}
\value{
data.table of PharmacoSet's dose response data with column names aligned with gDR standard
}
\description{
Convert a PharmacoSet to a data.table that is prepare for input into gDR pipeline
}
\examples{
pset <- suppressMessages(getPSet(
  "Tavor_2020", 
  psetDir = system.file("extdata/pset", package = "gDRimport"),
  use_local_PSets_list = TRUE
))
dt <- convert_pset_to_df(pset)
gDRutils::reset_env_identifiers()

}
\author{
Jermiah Joseph -- collaboration with BHKLab
}
\keyword{pset_conversion}
