% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_type.R
\name{identify_data_type}
\alias{identify_data_type}
\title{Identify type of data}
\usage{
identify_data_type(dt, codilution_conc = 2, matrix_conc = 1)
}
\arguments{
\item{dt}{data.table of raw drug response data
containing both treated and untreated values}

\item{codilution_conc}{integer of maximum number of concentration ratio
of co-treatment to classify as codilution data type;
defaults to \code{2}}

\item{matrix_conc}{integer of minimum number of concentration pairs
of co-treatment to classify
as co-treatment or matrix data type;
defaults to \code{1}}
}
\value{
data.table of raw drug response data with additional column \code{type}
with the info of data type for a given row of data.table
}
\description{
Identify type of data
}
\examples{
conc <- rep(seq(0, 0.3, 0.1), 2)
ctrl_dt <- S4Vectors::DataFrame(
  ReadoutValue = c(2, 2, 1, 1, 2, 1),
  Concentration = rep(0, 6),
  masked = FALSE,
  DrugName = rep(c("DRUG_10", "vehicle", "DRUG_8"), 2),
  CellLineName = "CELL1"
)

trt_dt <- S4Vectors::DataFrame(
  ReadoutValue = rep(seq(1, 4, 1), 2),
  Concentration = conc,
  masked = rep(FALSE, 8),
  DrugName = c("DRUG_10", "DRUG_8"),
  CellLineName = "CELL1"
)
input_dt <- data.table::as.data.table(rbind(ctrl_dt, trt_dt))
input_dt$Duration <- 72
input_dt$CorrectedReadout2 <- input_dt$ReadoutValue
identify_data_type(input_dt)
}
\author{
Bartosz Czech \href{mailto:bartosz.czech@contractors.roche.com}{bartosz.czech@contractors.roche.com}
}
\keyword{data_type}
