% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ViewGuides.R
\name{ct.viewGuides}
\alias{ct.viewGuides}
\title{Generate a Plot of individual gRNA Pair Data in a Crispr Screen}
\usage{
ct.viewGuides(
  gene,
  fit,
  ann,
  type = "geneSymbol",
  contrast.term = NULL,
  ylims = NULL
)
}
\arguments{
\item{gene}{the name of the target element of interest, contained within the 'type' column of the annotation file.}

\item{fit}{An object of class MArrayLM containing, at minimum, an 'Amean' slot containing the guide level abundances, 
a 'coefficients' slot containing the effect estimates for each guide, and an 'stdev.unscaled' slot giving the coefficient standard Deviations.}

\item{ann}{A data.frame object containing the gRNA annotations. 
At mimimum, it should have a column with the name specified by the \code{type} argument, containing the element targeted by each guide.}

\item{type}{A character string indicating the column in ann containing the target of interest.}

\item{contrast.term}{If a fit object with multiple coefficients is passed in, a string indiating the coefficient of interest.}

\item{ylims}{An optional numeric vector of length 2 indicating the extremes of the y-axis scale.}
}
\value{
An image summarizing gRNA behavior within the specifed gene on the default device.
}
\description{
This function generates a visualization of the effect estimates from a MArrayLM model result for all of the 
individual guides targeting a particular element, specified somewhere in the library annotation file. The estimated effect 
size and variance is plotted relative to zero for the specified contrast, with the color of the dot indicating the relative scale of the
of the guide intercept within the model framework, with warmer colors indicating lowly expressed guides. For comparison, the density of gRNA 
fold change estimates is privided in a pane on the right, with white lines indicating the exact levels of the individual guides.
}
\examples{
data('fit')
data('ann')
ct.viewGuides('Target1633', fit, ann)
}
\author{
Russell Bainer
}
