% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRAalpha.R
\name{ct.RRAalpha}
\alias{ct.RRAalpha}
\title{Aggregation of P-value Ranks using a Beta Distribution and Alpha Cutoff}
\usage{
ct.RRAalpha(p, g.key, shuffle = FALSE)
}
\arguments{
\item{p}{A single column matrix of rank statistics.}

\item{g.key}{data.frame with guide and gene names}

\item{shuffle}{Logical indicating whether to shuffle the rank statistics prior to calculating the rho statistics (useful for permutation).}
}
\value{
Nothing, or a named list of target-level P-values, which are treated as a rho statistic in the permutation step.
}
\description{
This function is called internally as a single instance of the beta aggregation step in RRAa. Users should not interact with it directly. 
The expected input is a set of rank statistics, and a paired \code{alpha} argument defining which values to consider in downstream analyses (see below). 

As of gCrisprTools 2.0, this function does not consider `row.names` associated with the provided values, and the p-values are expected to be provided 
in register with the provided `g.key` object.
}
\examples{
data('fit')
data('ann')
geneScores <- ct.RRAalpha(fit$p.value, ann, shuffle = FALSE)
}
\author{
Russell Bainer
}
\keyword{internal}
