% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{short_sets_detail}
\alias{short_sets_detail}
\title{Retrieve details and information about short molecular sets}
\usage{
short_sets_detail(sets, minsize)
}
\arguments{
\item{sets}{A list of molecular sets.}

\item{minsize}{The minimum size threshold for  sets.}
}
\value{
A list containing information about short molecular sets:
  \item{short_sets}{Names of the short molecular sets.}
  \item{lengths}{Lengths of the short molecular sets.}
  \item{genes}{Short molecular sets themselves.}
}
\description{
This function identifies molecular sets with sizes less than a specified threshold
and returns information about these sets.
}
\details{
This function identifies molecular sets in the input list that have sizes
  less than the specified minimum size (\code{minsize}). It returns a list
  containing the names, lengths, and molecules of these short molecular sets.
}
\examples{
ex_sets <- list(set1 = c("mol1", "mol2"), set2 = c("mol3", "mol4", "mol5"))
short_sets_info <- short_sets_detail(ex_sets, minsize = 3)
}
