% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{matchTrajToParticles}
\alias{matchTrajToParticles}
\title{Match trajectories to related particles.}
\usage{
matchTrajToParticles(particleset, trajectoryset)
}
\arguments{
\item{particleset}{A \code{ParticleSet} object}

\item{trajectoryset}{A \code{TrajectorySet} object coupled to the \code{particleset}}
}
\value{
A \code{ParticleSet} object with an additional column with the trajectory
IDs
}
\description{
Match trajectories to the related particles in the \code{TrajectorySet} and
\code{ParticleSet} objects. This function returns a new \code{ParticleSet}
object that contains as additional column the trajectory ID that the particular
particle was assigned to. Used also by other routines, such as \code{\link[=snap]{snap()}}
}
\examples{
data(candidate.platelets)
trajs <- trajectories(candidate.platelets)
matchTrajToParticles(candidate.platelets, trajs)

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2015
}
