% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSet_Methods.R
\name{transform}
\alias{transform}
\alias{transform,GatingSetList-method}
\alias{transform,GatingSet-method}
\title{tranform the flow data asssociated with the GatingSet}
\usage{
\S4method{transform}{GatingSet}(`_data`, translist, ...)
}
\arguments{
\item{_data}{\code{GatingSet} or \code{GatingSetList}}

\item{translist}{expect a \code{transformList} object or a list of \code{transformList} objects(with names matched to sample names)}

\item{...}{other arguments passed to 'transform' method for 'ncdfFlowSet'.(e.g. 'ncdfFile')}
}
\value{
a \code{GatingSet} or \code{GatingSetList} object with the underling flow data transformed.
}
\description{
The transformation functions are saved in the GatingSet and can be retrieved by \link{gh_get_transformations}.
Currently only flowJo-type biexponential transformation(either returned by \link{gh_get_transformations} or constructed by \link{flowJoTrans})
is supported.
}
\examples{
\dontrun{
library(flowCore)
data(GvHD)
fs <- GvHD[1:2]
gs <- GatingSet(fs)

#construct biexponential transformation function
biexpTrans <- flowjo_biexp_trans(channelRange=4096, maxValue=262144, pos=4.5,neg=0, widthBasis=-10)

#make a transformList object
chnls <- c("FL1-H", "FL2-H")
transList <- transformerList(chnls, biexpTrans)

#add it to GatingSet
gs_trans <- transform(gs, transList)

}
}
