% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_trans.R
\name{flowjo_fasinh_trans}
\alias{flowjo_fasinh_trans}
\alias{flowJo_fasinh_trans}
\title{flowJo inverse hyperbolic sine transformation.}
\usage{
flowjo_fasinh_trans(..., n = 6, equal.space = FALSE)

flowJo_fasinh_trans(...)
}
\arguments{
\item{...}{parameters passed to flowjo_fasinh}

\item{n}{desired number of breaks (the actual number will be different depending on the data range)}

\item{equal.space}{whether breaks at equal-spaced intervals}
}
\value{
fasinh transformation object
}
\description{
Used to construct the inverse hyperbolic sine transform object.
}
\examples{
trans.obj <- flowjo_fasinh_trans(equal.space = TRUE)
data <- 1:1e3
brks.func <- trans.obj[["breaks"]]
brks <- brks.func(data)
brks # fasinh space displayed at raw data scale

#transform it to verify it is equal-spaced at transformed scale
trans.func <- trans.obj[["transform"]]
round(trans.func(brks))
}
