% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover.R
\name{spillover_match-flowSet}
\alias{spillover_match-flowSet}
\alias{spillover_match}
\alias{spillover_match,flowSet-method}
\alias{spillover_match,missing-method}
\title{Construct a \code{flowSet} for use with \code{spillover} by matching channel
names to compensation control filenames}
\usage{
\S4method{spillover_match}{flowSet}(x, fsc = "FSC-A", ssc = "SSC-A",
                                    matchfile = NULL, path)

\S4method{spillover_match}{missing}(x, fsc = "FSC-A", ssc = "SSC-A", matchfile, path)
}
\arguments{
\item{x}{A flowSet of compensation beads or cells}

\item{fsc}{The name or index of the forward scatter parameter}

\item{ssc}{The name or index of the side scatter parameter}

\item{matchfile}{The name or path of the csv file holding the compensation control file
to channel matching information.}

\item{path}{The name or path of the directory containing the control FCS files to
be matched to channels by matchfile.}
}
\value{
A \code{flowSet} with the sample names of its \code{flowFrames}
corresponding to the channels specified by the matchfile.
}
\description{
Spillover information for a particular experiment is often obtained by
running several tubes of beads or cells stained with a single color that can
then be used to determine a spillover matrix for use with
\code{\link{compensate}}.\cr\cr
This method facilitates construction of a \code{flowSet} of compensation
control \code{flowFrame}s using a simple file linking filenames to channels.
This resulting \code{flowSet} can then be used with \code{\link{spillover}}
using the option \code{prematched = TRUE}.\cr\cr
Matching stain channels to compensation controls is done via a csv
file (\code{matchfile}) with columns 'filename' and 'channel'. The 'channel' entries should
exactly match the channel names in the FCS files. The 'filename' should be
the FCS file name of each compensation control which should also be the
corresponding sample name in the \code{flowSet}. There should also be one unstained
control with the 'channel' entry of 'unstained'.\cr\cr
The method also allows for \code{x} to be missing if \code{path} is provided,
pointing to a directory containing the control FCS files.\cr\cr
}
\seealso{
\code{\link{compensate}}, \code{\link{spillover}}
}
\author{
B. Ellis, J. Wagner
}
\keyword{methods}
