% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowAnalysis.R
\name{fhAnalyze}
\alias{fhAnalyze}
\title{fhAnalyze}
\usage{
fhAnalyze(fh, verbose = TRUE)
}
\arguments{
\item{fh}{a \code{\link{FlowHist}} object}

\item{verbose}{boolean, set to FALSE to turn off logging messages}
}
\value{
a \code{\link{FlowHist}} object with the analysis (nls, counts,
  cv, RCS) slots filled.
}
\description{
Complete non-linear regression analysis of FlowHist histogram data
}
\details{
Completes the NLS analysis, and calculates the modelled events and CVs
for the result.
}
\examples{
library(flowPloidyData)
fh1 <- FlowHist(file = flowPloidyFiles()[1], channel = "FL3.INT.LIN")
fh1 <- fhAnalyze(fh1)
}
\seealso{
\code{\link{FlowHist}}
}
\author{
Tyler Smith
}
