% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_helpers.R
\name{mean_diff}
\alias{mean_diff}
\title{Normalizes matrix values by class.}
\usage{
mean_diff(m0, classes)
}
\arguments{
\item{m0}{A numeric matrix.}

\item{classes}{A vector whose length is equal to the number of
rows in the given matrix.}
}
\value{
A numeric matrix whose dimensions equate to that of the input
 and whose values are normalized per class.
}
\description{
Used only in the \code{\link[flowGraph]{fg_feat_mean_class}}
 function; for each class in the \code{classes} vector,
 \code{meandiff} takes the column mean
 of the rows in the given matrix associated with that class;
 it then takes the difference point by point between these means and
 the original rows for that class.
}
\examples{

 classes <- append(rep('apples',4), rep('oranges',3))
 m0 <- matrix(rnorm(35), nrow=7)
 m <- flowGraph:::mean_diff(m0, classes)

}
\seealso{
\code{\link[flowGraph]{fg_feat_mean_class}}
}
