% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_flowgraph_plots.R
\name{fg_plot_pVSdiff}
\alias{fg_plot_pVSdiff}
\title{Creates a p value vs feature difference plot}
\usage{
fg_plot_pVSdiff(
  fg,
  type = "node",
  index = 1,
  summary_meta = NULL,
  adjust_custom = "byLayer",
  logged = TRUE,
  label_max = 5,
  p_thres = 0.05,
  filter_adjust0 = 1,
  filter_es = 0,
  filter_btwn_tpthres = 1,
  filter_btwn_es = 0,
  shiny_plot = FALSE,
  nodes_max = 30,
  main = NULL,
  interactive = FALSE,
  path = NULL
)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summary was created for
'node' or 'edge'.}

\item{index}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{index} is an integer indicating the row in
 \code{fg_get_summary_desc(<flowGraph>)} of the corresponding type and
 summary the user would like to retrieve.}

\item{summary_meta}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{summary_meta} is a list containing
 \code{feature} (feature name), \code{test_name} (summary statistic name),
 \code{class} (class), \code{label1}, and \code{label2} (class labels compared).
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.}

\item{adjust_custom}{A function or a string indicating the
test adjustment method to use.
 If a string is provided, it should be one of
 \code{c("holm", "hochberg", "hommel",
 "bonferroni", "BH", "BY", "fdr", "none")} (see \code{p.adjust.methods}).
 If a function is provided, it should take as input
 a numeric vector and output the
 same vector adjusted.}

\item{logged}{A logical indicating whether or not to log the summary
statistic p value.}

\item{label_max}{An integer indicating the maximum number of max difference
and/or min p value nodes/edges that should be labelled.}

\item{p_thres}{A numeric variable indicating a p-value threshold; a line will
be plotted at this threshold.}

\item{filter_adjust0}{A numeric variable indicating what percentage of
SpecEnr values compared (minimum) should be not close to 0.
Set to 1 to not conduct filtering.}

\item{filter_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant.}

\item{filter_btwn_tpthres}{A numeric variable between 0 and 1 indicating the
unadjusted T-test p-value threshold used to test whether the actual
and expected feature values used to calculate the specified SpecEnr
feature are significantly different for each sample class. Note this only
needs to be specified for SpecEnr features. Combined
with \code{filter_btwn_es}, we conduct three tests to understand if
there is an actual large difference between actual and expected features:
(1,2) T-test of significance between the actual and expected raw feature value
(e.g. proportion) for samples in each of the compared classes, (3) and the
T-test of significance between the differences of actual and
expected feature values of the two classes. If any two of the three tests
come out as insignificant, we set the p-value for the associated node/edge
to 1.}

\item{filter_btwn_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant -- see \code{filter_btwn_tpthres}.}

\item{shiny_plot}{A logical indicating whether this plot is made for shiny;
users don't need to change this.}

\item{nodes_max}{An integer indicating maximum number of nodes to plot;
this limit is set for interactive plots only.}

\item{main}{A string or the title of the plot; if left as \code{NULL},
a default title will be applied.}

\item{interactive}{A logical variable indicating whether the plot should be
an interactive plot; see package \code{ggiraph}.}

\item{path}{A string indicating the path to where the function should save
the plot; leave as \code{NULL} to not save the plot. Static plots are saved
as PNG.}
}
\value{
A static or interactive p value vs difference plot.
}
\description{
Creates a p value vs feature difference plot where the
 difference is that of the
 features of samples belonging to different classes corresponding
 to an existing summary statistic.
}
\details{
The interactive plot is made using the \code{ggiraph} package.
}
\examples{

 no_cores <- 1
 data(fg_data_pos2)
 fg <- flowGraph(fg_data_pos2$count, class=fg_data_pos2$meta$class,
                 no_cores=no_cores)

 gp <- fg_plot_pVSdiff(fg, type="node", summary_meta=NULL,
                       adjust_custom="byLayer", index=1, label_max=10)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_plot}}
 \code{\link[flowGraph]{plot_gr}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_get_summary}}
 \code{\link[flowGraph]{fg_plot_qq}}
}
