% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_summary_index}
\alias{fg_get_summary_index}
\title{Retrieves the index of the requested summary.}
\usage{
fg_get_summary_index(fg, type = "node", index = NULL, summary_meta = NULL)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summary was created for
'node' or 'edge'.}

\item{index}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{index} is an integer indicating the row in
 \code{fg_get_summary_desc(<flowGraph>)} of the corresponding type and
 summary the user would like to retrieve.}

\item{summary_meta}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{summary_meta} is a list containing
 \code{type} (feature type: \code{node} or \code{edge}),
 \code{feature} (feature name), \code{test_name} (summary statistic name),
 \code{class} (class), \code{lable1}, and \code{label2} (class labels compared).
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.}
}
\value{
An integer analagous to \code{index}.
 If both \code{index} and \code{summary_meta} are \code{NULL}, returns 1.
}
\description{
Retrieves the index of the requested summary
 from a given flowGraph object.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 no_cores=no_cores)

 # set features to NULL to apply summary statistic to all features.
 fg <- fg_summary(fg, no_cores=no_cores, class="class", label1="control",
                  overwrite=FALSE, test_name="t", diminish=FALSE,
                  node_features=NULL, edge_features=NULL)
 show(fg)

 index <- flowGraph:::fg_get_summary_index(
  fg, type="node", summary_meta=list(
    feature="SpecEnr", test_name="t", class="class",
    label1="control", label2="exp"))

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
 \code{\link[flowGraph]{fg_add_summary}}
 \code{\link[flowGraph]{fg_rm_summary}}
 \code{\link[flowGraph]{fg_plot}}
}
