% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_flowgraph_features.R
\name{fg_feat_mean_class}
\alias{fg_feat_mean_class}
\title{Normalizes all features for class.}
\usage{
fg_feat_mean_class(
  fg,
  class,
  no_cores = 1,
  node_features = NULL,
  edge_features = NULL
)
}
\arguments{
\item{fg}{PARAM_DESCRIPTION}

\item{class}{a column name in \code{fg_get_meta(fg)} indicating the
meta data that should be used as the class label of each sample
while conudcting normalization.}

\item{no_cores}{An integer indicating how many cores to parallelize on.}

\item{node_features}{A string vector indicating the node features to
perform normalization on; set as \code{NULL} to normalize all.}

\item{edge_features}{A string vector indicating the edge features to
perform normalization on; set as \code{NULL} to normalize all.}
}
\value{
A numeric matrix whose dimensions equate to that of the input
 and whose values are normalized per class.

flowGraph object with normalized features.
}
\description{
For each class label in column \code{class} of \code{meta},
 \code{fg_feat_mean_class}
 takes the column mean of the rows in the given feature matrices
 (as specified in \code{node_features} and \code{edge_features})
 associated with that class;
 it then takes the difference point by point between these means and
 the original rows for that class.

FUNCTION_DESCRIPTION
}
\details{
For all features in the given \code{flowGraph} object and for
 each class label in column \code{class} of \code{meta},
 \code{fg_feat_mean_class}. It takes the column mean of the rows in the given
 feature matrices
 (as specified in \code{node_features} and \code{edge_features})
 associated with that class;
 it then takes the difference point by point between these means and
 the original rows for that class.
 \code{fg_feat_mean_class}
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg <- fg_feat_mean_class(fg, class="class", node_features="count",
                        no_cores=no_cores)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
}
