% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgseaORA.R
\name{collapsePathwaysORA}
\alias{collapsePathwaysORA}
\title{Collapse list of enriched pathways to independent ones. Version for ORA hypergeometric test.}
\usage{
collapsePathwaysORA(foraRes, pathways, genes, universe, pval.threshold = 0.05)
}
\arguments{
\item{foraRes}{Table with results of running fgsea(), should be filtered
by p-value, for example by selecting ones with padj < 0.01.}

\item{pathways}{List of pathways, should contain all the pathways present in
`fgseaRes`.}

\item{genes}{Set of query genes, same as in `fora()`}

\item{universe}{A universe from whiche `genes` were selected, same as in `fora()`}

\item{pval.threshold}{Two pathways are considered dependent when p-value
of enrichment of one pathways on background of another
is greater then `pval.threshold`.}
}
\value{
Named list with two elments: `mainPathways` containing IDs of pathways
        not reducable to each other, and `parentPathways` with vector describing
        for all the pathways to which ones they can be reduced. For
        pathways from `mainPathwyas` vector `parentPathways` contains `NA` values.
}
\description{
Collapse list of enriched pathways to independent ones. Version for ORA hypergeometric test.
}
\examples{
data(examplePathways)
data(exampleRanks)
foraRes <- fora(examplePathways, genes=tail(names(exampleRanks), 200), universe=names(exampleRanks))
collapsedPathways <- collapsePathwaysORA(foraRes[order(pval)][padj < 0.01],
                                             examplePathways,
                                             genes=tail(names(exampleRanks), 200),
                                             universe=names(exampleRanks))

mainPathways <- foraRes[pathway \%in\% collapsedPathways$mainPathways][
                          order(pval), pathway]
}
