% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg.R
\name{fetch_kegg}
\alias{fetch_kegg}
\title{Get functional term data from KEGG}
\usage{
fetch_kegg(species, batch_size = 10, on_error = c("stop", "warn", "ignore"))
}
\arguments{
\item{species}{KEGG species code, for example "hsa" for human. The
full list of available KEGG species can be found by using \code{fetch_kegg_species}.}

\item{batch_size}{Number of pathways sent to KEGG database in one query. The
maximum allowed is 10.}

\item{on_error}{A character string indicating the error handling strategy:
either "stop" to halt execution, "warn" to issue a warning and return
`NULL` or "ignore" to return `NULL` without warnings. Defaults to "stop".}
}
\value{
A list with \code{terms} and \code{mapping} tibbles.
}
\description{
Download information (pathway ID and name) and gene-pathway mapping (entrez
gene ID, gene symbol and pathway ID) from KEGG. Gene symbols are extracted
from gene descriptions. For some species (e.g. yeast), gene symbols are
returned instead of entrez IDs and not in gene description.
}
\examples{
kegg_data <- fetch_kegg("mge", on_error = "warn")
}
