% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{fetch_go_species}
\alias{fetch_go_species}
\title{Find all species available from geneontology.org}
\usage{
fetch_go_species(on_error = c("stop", "warn", "ignore"))
}
\arguments{
\item{on_error}{A character string indicating the error handling strategy:
either "stop" to halt execution, "warn" to issue a warning and return
`NULL` or "ignore" to return `NULL` without warnings. Defaults to "stop".}
}
\value{
A tibble with columns \code{species} and \code{designation}.
}
\description{
This function attempts to scrape HTML web page containing a table of
available species and corresponding file names. If the structure of the page
changes one day and the function stops working, go to
\url{http://current.geneontology.org/products/pages/downloads.html} and check
file names. The species designation used in this package is the GAF file name
without extension (e.g. for a file \file{goa_chicken.gaf} the designation is
\file{goa_chicken}).
}
\examples{
go_species <- fetch_go_species(on_error = "warn")
}
