% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{get_term_features}
\alias{get_term_features}
\title{Get features annotated with a given term.}
\usage{
get_term_features(term_data, term_id)
}
\arguments{
\item{term_data}{An object class \code{fenr_terms}, created by
\code{prepare_for_enrichment}.}

\item{term_id}{A string with a functional term ID.}
}
\value{
A character vector containing feature IDs annotated with the term ID.
}
\description{
Get features annotated with a given term.
}
\examples{
\dontrun{
go_data <- fetch_go(species = "sgd")
go_terms <- prepare_for_enrichment(go_data$terms, go_data$mapping, feature = "gene_symbol")
feats <- get_term_features(go_terms, "GO:0000001")
}
}
