% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDiffStatus.R
\name{addDiffStatus}
\alias{addDiffStatus}
\alias{addDiffStatus,data.frame-method}
\alias{addDiffStatus,DataFrame-method}
\alias{addDiffStatus,GRanges-method}
\alias{addDiffStatus,GRangesList-method}
\alias{addDiffStatus,SummarizedExperiment-method}
\title{Add a status column}
\usage{
addDiffStatus(x, ...)

\S4method{addDiffStatus}{data.frame}(
  x,
  fc_col = "logFC",
  sig_col = c("FDR", "hmp_fdr", "p_fdr", "adj.P.Value"),
  alpha = 0.05,
  cutoff = 0,
  up = "Increased",
  down = "Decreased",
  other = "Unchanged",
  missing = "Undetected",
  new_col = "status",
  drop = FALSE,
  ...
)

\S4method{addDiffStatus}{DataFrame}(x, new_col = "status", ...)

\S4method{addDiffStatus}{GRanges}(x, ...)

\S4method{addDiffStatus}{GRangesList}(x, ...)

\S4method{addDiffStatus}{SummarizedExperiment}(x, ...)
}
\arguments{
\item{x}{Object to be classified}

\item{...}{Used to pass arguments between methods}

\item{fc_col}{Name of the fold-change column}

\item{sig_col}{Name of the column with significance values}

\item{alpha}{significance threshold}

\item{cutoff}{minimum estimated change to be considered in either of the up
or down categories}

\item{up, down, other}{factor levels to annotate regions based on the above
criteria}

\item{missing}{Value to add when either fc_col or sig_col has NA values}

\item{new_col}{name of the new column to be added}

\item{drop}{logical(1) Drop unused factor levels from the status column}
}
\value{
An object of the same type as provided
}
\description{
Add a status column based on significance and estimated change
}
\details{
This takes a simple object and adds a new column classifying entries into
one of three categories, as specified using \code{up}, \code{down} or \code{other}.
Results in the new column will always be returned as a factor with levels in
order of the values provided in the arguments \code{other}, \code{down} and \code{up}
}
\examples{
## Working with a data.frame
set.seed(101)
df <- data.frame(logFC = rnorm(20), p = rbeta(20, shape1 = 1, shape2 = 20))
df$FDR <- p.adjust(df$p, "fdr")
addDiffStatus(df)

## This works identically with a GRanges object, amongst others
gr <- GRanges(paste0("chr1:", seq_len(20)))
mcols(gr) <- df
addDiffStatus(gr)

}
