% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsAnalysis.R
\name{annotateClustersByMetric}
\alias{annotateClustersByMetric}
\title{Calculate the cluster ID from the optimal cluster per metric for each individual.
annotateClustersByMetric}
\usage{
annotateClustersByMetric(df, k.range, bs, seed)
}
\arguments{
\item{df}{Input data frame. The first column denotes the identifier of the
evaluated individuals. The remaining columns contain the metrics used to
evaluate the individuals. Rows with NA values will be ignored.}

\item{k.range}{Range of k values in which the optimal k will be searched}

\item{bs}{Bootstrap re-sample param.}

\item{seed}{Random seed to be used.}
}
\value{
A named list resulting from computing the optimal cluster for each
metric. Each metric is a name in the named list, and its content is a
data frame that includes the individuals, the value for the corresponding
metric, and the cluster id in which the individual has been asigned according
to the optimal cluster.
}
\description{
Return a named list, where each metric name is linked to a data frame
containing the evaluated individuals, their score for the specified metric,
and the cluster id in which each individual is classified. This cluster
assignment is performed by calculating the optimal k value by evaluome.
}
\examples{
data("ontMetrics")
annotated_clusters=annotateClustersByMetric(ontMetrics, k.range=c(2,3), bs=20, seed=100)
annotated_clusters[['ANOnto']]
}
