% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapEnrichment.R
\name{heatmapEnrichment}
\alias{heatmapEnrichment}
\title{Visualize Enrichment Value Summaries Using Heatmaps}
\usage{
heatmapEnrichment(
  input.data,
  assay = NULL,
  group.by = NULL,
  gene.set.use = "all",
  cluster.rows = FALSE,
  cluster.columns = FALSE,
  facet.by = NULL,
  scale = FALSE,
  summary.stat = "mean",
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single-cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Character. Name of the assay holding enrichment scores when
\code{input.data} is a single-cell object. Ignored otherwise.}

\item{group.by}{Character. Metadata column plotted on the x-axis. Defaults
to the Seurat/SCE \code{ident} slot when \code{NULL}.}

\item{gene.set.use}{Character vector or \code{"all"}. Gene-set names to
plot. Use \code{"all"} (default) to show every available gene set.}

\item{cluster.rows}{Logical. If \code{TRUE}, rows are ordered by Ward-linkage
hierarchical clustering (Euclidean distance). Default is \code{FALSE}.}

\item{cluster.columns}{Logical. If \code{TRUE}, columns are ordered by
Ward-linkage hierarchical clustering (Euclidean distance). Default is
\code{FALSE}.}

\item{facet.by}{Character or \code{NULL}. Metadata column used to facet
the plot.}

\item{scale}{Logical. If \code{TRUE}, Z-transforms each gene-set column
\strong{after} summarization. Default is \code{FALSE}.}

\item{summary.stat}{Character. Method used to summarize expression within
each group. One of: \code{"mean"} (default), \code{"median"},
\code{"max"}, \code{"sum"}, or \code{"geometric"}.}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}
}
\value{
A \code{ggplot2} object.
}
\description{
This function allows the user to examine a heatmap with the mean enrichment
values by group. The heatmap displays gene sets as rows and the grouping
variable as columns.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
           
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs, min.size = NULL)
  
heatmapEnrichment(pbmc, assay = "escape", palette = "viridis")

}
