% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGeneSets.R
\name{getGeneSets}
\alias{getGeneSets}
\title{Get a Collection of Gene Sets from MSigDB}
\usage{
getGeneSets(
  species = c("Homo sapiens", "Mus musculus"),
  library = NULL,
  subcategory = NULL,
  gene.sets = NULL,
  version = "7.4",
  id = "SYM"
)
}
\arguments{
\item{species}{Character. Species name. Either \code{"Homo sapiens"}
(default) or \code{"Mus musculus"}.}

\item{library}{Character or \code{NULL}. Vector of main collection codes
(e.g., \code{"H"}, \code{"C5"}). Default is \code{NULL} (all collections).}

\item{subcategory}{Character or \code{NULL}. Vector of sub-collection codes
(e.g., \code{"GO:BP"}). Default is \code{NULL} (all subcategories).}

\item{gene.sets}{Character or \code{NULL}. Vector of specific gene-set
names. Default is \code{NULL} (all gene sets).}

\item{version}{Character. MSigDB version. Default is \code{"7.4"}.}

\item{id}{Character. Identifier type. Default is \code{"SYM"} (gene
symbols).}
}
\value{
A named list of character vectors (gene IDs).
}
\description{
This function retrieves gene sets from MSigDB and caches the downloaded
object for future calls. It allows subsetting by main collection (library),
subcollection, or specific gene sets, and only supports human
(\code{"Homo sapiens"}) and mouse (\code{"Mus musculus"}).
}
\examples{
\dontrun{
# Get all hallmark gene sets from human.
gs <- getGeneSets(species = "Homo sapiens",
                  library = "H")

# Get a subset based on main collection and subcollection.
gs <- getGeneSets(species = "Homo sapiens",
                  library = c("C2", "C5"),
                  subcategory = "GO:BP")
}

}
