% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichIt.R
\name{enrichIt}
\alias{enrichIt}
\title{Flexible GSEA for Precomputed Gene Lists}
\usage{
enrichIt(
  input.data,
  gene.sets,
  gene_col = NULL,
  logFC_col = "avg_log2FC",
  pval_col = c("p_val_adj", "p_val"),
  ranking_fun = c("signed_log10_p", "logFC"),
  pval_cutoff = 1,
  logFC_cutoff = 0,
  minSize = 5,
  maxSize = 500,
  padjust_method = "BH",
  nproc = 0
)
}
\arguments{
\item{input.data}{Either
• a named numeric vector **already ranked**, *or*  
• a data.frame/tibble with one row per gene and columns containing
  log-fold-change and *p*-value. If the gene ID is not in `rownames(data)`,
  supply `gene_col`.}

\item{gene.sets}{AA named list of character vectors, the result of
[getGeneSets()], or the built-in data object [escape.gene.sets].}

\item{gene_col}{Name of the column holding gene identifiers (ignored when 
they are row-names). Default `NULL`.}

\item{logFC_col, pval_col}{Column names for logFC and *p* (or adj.*p*)
– defaults match Seurat’s `FindMarkers()`.}

\item{ranking_fun}{How to build the ranking: `"signed_log10_p"` (default) 
or `"logFC"`.}

\item{pval_cutoff, logFC_cutoff}{Filters applied **before** ranking.}

\item{minSize, maxSize}{Integer. Minimum / maximum pathway size passed to
*fgsea* (default 5 / 500).}

\item{padjust_method}{Multiple-testing correction; any method accepted by
[stats::p.adjust()] (default `"BH"`).}

\item{nproc}{Passed to **fgsea** (`0` = multithread if OpenMP available).}
}
\value{
`data.frame` with the usual fgsea columns plus a convenient
`leadingEdge` character column collapsed with \";\".
}
\description{
A convenience front-end to **fgsea** that lets you point at the
`avg_log2FC` and `p_val_adj` columns coming out of Seurat / DESeq2 /
edgeR etc. It converts them to a signed -log10(*p*) ranking, filters on
significance / effect size, and then runs fgsea.
}
\examples{
pbmc_small <- SeuratObject::pbmc_small

Seurat::Idents(pbmc_small) <- "groups"
markers <- Seurat::FindMarkers(pbmc_small, 
                               ident.1 = "g1", 
                               ident.2 = "g2")

gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
               
gsea <- enrichIt(markers, 
                 gene.sets = gs)

}
\seealso{
[fgsea::fgsea()], [getGeneSets()], [gseaEnrichment()]
}
