% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSNPs.R
\name{RSNPs}
\alias{RSNPs}
\alias{atacSNPAnno,ATACProc-method}
\alias{atacSNPAnno}
\alias{snpanno}
\title{Find whether snps are in the given regions.}
\usage{
atacSNPAnno(
  atacProc,
  snp.info = NULL,
  region.info = NULL,
  annoOutput = NULL,
  ...
)

\S4method{atacSNPAnno}{ATACProc}(
  atacProc,
  snp.info = NULL,
  region.info = NULL,
  annoOutput = NULL,
  ...
)

snpanno(snp.info = NULL, region.info = NULL, annoOutput = NULL, ...)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacPeakCalling}}
\code{\link{atacMotifScan}}.
If from \code{\link{atacPeakCalling}}, the output file would contain the snps
in given region. If from \code{\link{atacMotifScan}}, the output file would
contain file path to the output of every motif.}

\item{snp.info}{\code{Character} scalar.
Input snp info path. There are two type of input files(you can specify by
parameter withend).
1.The first 2 column must be chr, position.
e.g. chr13   39776775    rs7993214.
Other columns could be other information about snps.
2.The first 3 column must be chr, start, end.
e.g. chr13   39776775    39776775    rs7993214.
Other columns could be other information about snps.
When genome is hg19, using human disease as default.}

\item{region.info}{\code{Character} scalar.
Input region info path. The first 3 column must be chr, position, end. The
standard BED format is recommended.}

\item{annoOutput}{\code{Character} scalar.
Output path.}

\item{...}{withend Your snp data has only one position column or 2.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar.
}
\description{
Find snps(user providing) in given regions.
This function do not consider strand.
}
\examples{

library(R.utils)
p1bz <- system.file("extdata", "Example_peak1.bed.bz2", package="esATAC")
peak1_path <- as.vector(bunzip2(filename = p1bz,
destname = file.path(getwd(), "Example_peak1.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
snps <- system.file("extdata", "snp_info", package="esATAC")
#snpanno(snp.info = snps, region.info = peak1_path)

}
\seealso{
\code{\link{atacPeakCalling}}
\code{\link{atacMotifScan}}
}
\author{
Wei Zhang
}
